/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.functions;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.UnknownHostException;
import java.util.Map;
import org.easymock.classextension.EasyMock;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.internal.LocationImpl;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.compute.functions.ServerToNodeMetadata;
import org.jclouds.gogrid.compute.suppliers.GoGridHardwareSupplier;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.domain.ServerState;
import org.jclouds.gogrid.services.GridServerClient;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="gogrid.ServerToNodeMetadataTest")
public class ServerToNodeMetadataTest {
    @Test
    public void testApplySetsTagFromNameAndCredentialsFromName() throws UnknownHostException {
        GoGridClient caller = (GoGridClient)EasyMock.createMock(GoGridClient.class);
        GridServerClient client = (GridServerClient)EasyMock.createMock(GridServerClient.class);
        org.easymock.EasyMock.expect((Object)caller.getServerServices()).andReturn((Object)client).atLeastOnce();
        Map serverStateToNodeState = (Map)EasyMock.createMock(Map.class);
        Image jcImage = (Image)EasyMock.createMock(Image.class);
        Option dc = new Option(Long.valueOf(1L), "US-West-1", "US West 1 Datacenter");
        Option ram = new Option(Long.valueOf(1L), "512MB", "Server with 512MB RAM");
        ImmutableSet images = ImmutableSet.of((Object)jcImage);
        Server server = (Server)EasyMock.createMock(Server.class);
        org.easymock.EasyMock.expect((Object)server.getId()).andReturn((Object)1000L).atLeastOnce();
        org.easymock.EasyMock.expect((Object)server.getName()).andReturn((Object)"tag-ff").atLeastOnce();
        org.easymock.EasyMock.expect((Object)server.getState()).andReturn((Object)ServerState.ON).atLeastOnce();
        org.easymock.EasyMock.expect(serverStateToNodeState.get(ServerState.ON)).andReturn((Object)NodeState.RUNNING);
        LocationImpl location = new LocationImpl(LocationScope.ZONE, "1", "US-West-1", null);
        ImmutableMap locations = ImmutableMap.of((Object)"1", (Object)location);
        Map credentialsMap = (Map)EasyMock.createMock(Map.class);
        org.easymock.EasyMock.expect((Object)client.getServerCredentialsList()).andReturn((Object)credentialsMap);
        org.easymock.EasyMock.expect(credentialsMap.get("tag-ff")).andReturn((Object)new Credentials("user", "pass"));
        org.easymock.EasyMock.expect((Object)server.getIp()).andReturn((Object)new Ip("127.0.0.1"));
        ServerImage image = (ServerImage)EasyMock.createMock(ServerImage.class);
        org.easymock.EasyMock.expect((Object)server.getImage()).andReturn((Object)image).atLeastOnce();
        org.easymock.EasyMock.expect((Object)server.getRam()).andReturn((Object)ram).atLeastOnce();
        org.easymock.EasyMock.expect((Object)server.getDatacenter()).andReturn((Object)dc).atLeastOnce();
        org.easymock.EasyMock.expect((Object)image.getId()).andReturn((Object)2000L).atLeastOnce();
        org.easymock.EasyMock.expect((Object)jcImage.getProviderId()).andReturn((Object)"2000").atLeastOnce();
        org.easymock.EasyMock.expect((Object)jcImage.getLocation()).andReturn((Object)location).atLeastOnce();
        org.easymock.EasyMock.expect((Object)jcImage.getOperatingSystem()).andReturn(EasyMock.createMock(OperatingSystem.class)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{caller});
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{serverStateToNodeState});
        EasyMock.replay((Object[])new Object[]{server});
        EasyMock.replay((Object[])new Object[]{image});
        EasyMock.replay((Object[])new Object[]{jcImage});
        EasyMock.replay((Object[])new Object[]{credentialsMap});
        ServerToNodeMetadata parser = new ServerToNodeMetadata(serverStateToNodeState, caller, Suppliers.ofInstance((Object)images), Suppliers.ofInstance((Object)GoGridHardwareSupplier.H_ALL), Suppliers.ofInstance((Object)locations));
        NodeMetadata metadata = parser.apply(server);
        Assert.assertEquals((Object)metadata.getLocation(), (Object)location);
        Assert.assertEquals((String)metadata.getImageId(), (String)"2000");
        Assert.assertEquals((String)metadata.getTag(), (String)"tag");
        Assert.assertEquals((Object)metadata.getCredentials(), (Object)new Credentials("user", "pass"));
        EasyMock.verify((Object[])new Object[]{caller});
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{serverStateToNodeState});
        EasyMock.verify((Object[])new Object[]{image});
        EasyMock.verify((Object[])new Object[]{credentialsMap});
        EasyMock.verify((Object[])new Object[]{server});
        EasyMock.verify((Object[])new Object[]{jcImage});
    }
}

