/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.functions;

import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.gogrid.config.DateSecondsAdapter;
import org.jclouds.gogrid.domain.IpState;
import org.jclouds.gogrid.domain.ServerImageState;
import org.jclouds.gogrid.domain.ServerImageType;
import org.jclouds.gogrid.domain.ServerState;
import org.jclouds.gogrid.functions.ParseCredentialsFromJsonResponse;
import org.jclouds.gogrid.functions.internal.CustomDeserializers;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="gogrid.ParseCredentialsFromJsonResponseTest")
public class ParseCredentialsFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule(){

        protected void configure() {
            this.bind(GsonModule.DateAdapter.class).to(DateSecondsAdapter.class);
            super.configure();
        }

        @Provides
        @Singleton
        @Named(value="jclouds.gson-adapters")
        public Map<Type, Object> provideCustomAdapterBindings() {
            HashMap bindings = Maps.newHashMap();
            bindings.put(IpState.class, new CustomDeserializers.IpStateAdapter());
            bindings.put(ServerImageType.class, new CustomDeserializers.ServerImageTypeAdapter());
            bindings.put(ServerImageState.class, new CustomDeserializers.ServerImageStateAdapter());
            bindings.put(ServerState.class, new CustomDeserializers.ServerStateAdapter());
            return bindings;
        }
    }});

    @Test(expectedExceptions={IllegalStateException.class})
    public void testFailWhenTooManyPasswords() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_credentials_list.json");
        HttpResponse response = new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is));
        ParseCredentialsFromJsonResponse parser = (ParseCredentialsFromJsonResponse)this.i.getInstance(ParseCredentialsFromJsonResponse.class);
        parser.apply(response);
    }

    @Test
    public void testValid() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_credential.json");
        HttpResponse response = new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is));
        ParseCredentialsFromJsonResponse parser = (ParseCredentialsFromJsonResponse)this.i.getInstance(ParseCredentialsFromJsonResponse.class);
        Credentials creds = parser.apply(response);
        Assert.assertEquals((String)creds.identity, (String)"root");
        Assert.assertEquals((String)creds.credential, (String)"dig44sos");
    }
}

