/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.functions;

import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.UnknownHostException;
import org.jclouds.gogrid.config.DateSecondsAdapter;
import org.jclouds.gogrid.domain.internal.ErrorResponse;
import org.jclouds.gogrid.functions.ParseErrorFromJsonResponse;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.json.config.GsonModule;
import org.testng.annotations.Test;

public class ParseErrorFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule(){

        protected void configure() {
            this.bind(GsonModule.DateAdapter.class).to(DateSecondsAdapter.class);
            super.configure();
        }
    }});

    @Test
    public void testApplyInputStreamDetails() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_error_handler.json");
        ParseErrorFromJsonResponse parser = (ParseErrorFromJsonResponse)this.i.getInstance(ParseErrorFromJsonResponse.class);
        ErrorResponse response = (ErrorResponse)Iterables.getOnlyElement((Iterable)parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is))));
        assert ("No object found that matches your input criteria.".equals(response.getMessage()));
        assert ("IllegalArgumentException".equals(response.getErrorCode()));
    }
}

