/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.functions;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.inject.Singleton;
import org.jclouds.gogrid.config.DateSecondsAdapter;
import org.jclouds.gogrid.domain.Job;
import org.jclouds.gogrid.domain.JobProperties;
import org.jclouds.gogrid.domain.JobState;
import org.jclouds.gogrid.domain.ObjectType;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.functions.ParseJobListFromJsonResponse;
import org.jclouds.gogrid.functions.internal.CustomDeserializers;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="gogrid.ParseJobsFromJsonResponseTest")
public class ParseJobsFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule(){

        protected void configure() {
            this.bind(GsonModule.DateAdapter.class).to(DateSecondsAdapter.class);
            super.configure();
        }

        @Provides
        @Singleton
        @Named(value="jclouds.gson-adapters")
        public Map<Type, Object> provideCustomAdapterBindings() {
            HashMap bindings = Maps.newHashMap();
            bindings.put(ObjectType.class, new CustomDeserializers.ObjectTypeAdapter());
            bindings.put(JobState.class, new CustomDeserializers.JobStateAdapter());
            return bindings;
        }
    }});

    @Test
    public void testApplyInputStreamDetails() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_get_job_list.json");
        ParseJobListFromJsonResponse parser = (ParseJobListFromJsonResponse)this.i.getInstance(ParseJobListFromJsonResponse.class);
        SortedSet response = parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        TreeMap details = Maps.newTreeMap();
        details.put("description", null);
        details.put("image", "GSI-f8979644-e646-4711-ad58-d98a5fa3612c");
        details.put("ip", "204.51.240.189");
        details.put("name", "ServerCreated40562");
        details.put("type", "virtual_server");
        Job job = new Job(250628L, new Option(Long.valueOf(7L), "DeleteVirtualServer", "Delete Virtual Server"), ObjectType.VIRTUAL_SERVER, new Date(1267404528895L), new Date(1267404538592L), JobState.SUCCEEDED, 1, "3116784158f0af2d-24076@api.gogrid.com", (SortedSet)ImmutableSortedSet.of((Comparable)new JobProperties(940263L, new Date(1267404528897L), JobState.CREATED, null), (Comparable)new JobProperties(940264L, new Date(1267404528967L), JobState.QUEUED, null)), (Map)details);
        Assert.assertEquals((Object)job, (Object)Iterables.getOnlyElement((Iterable)response));
    }
}

