/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.functions;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.inject.Singleton;
import org.jclouds.gogrid.config.DateSecondsAdapter;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.gogrid.domain.IpState;
import org.jclouds.gogrid.domain.LoadBalancer;
import org.jclouds.gogrid.domain.LoadBalancerOs;
import org.jclouds.gogrid.domain.LoadBalancerPersistenceType;
import org.jclouds.gogrid.domain.LoadBalancerState;
import org.jclouds.gogrid.domain.LoadBalancerType;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.functions.ParseLoadBalancerListFromJsonResponse;
import org.jclouds.gogrid.functions.internal.CustomDeserializers;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="gogrid.ParseLoadBalancersFromJsonResponseTest")
public class ParseLoadBalancersFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule(){

        protected void configure() {
            this.bind(GsonModule.DateAdapter.class).to(DateSecondsAdapter.class);
            super.configure();
        }

        @Provides
        @Singleton
        @Named(value="jclouds.gson-adapters")
        public Map<Type, Object> provideCustomAdapterBindings() {
            HashMap bindings = Maps.newHashMap();
            bindings.put(LoadBalancerOs.class, new CustomDeserializers.LoadBalancerOsAdapter());
            bindings.put(LoadBalancerState.class, new CustomDeserializers.LoadBalancerStateAdapter());
            bindings.put(LoadBalancerPersistenceType.class, new CustomDeserializers.LoadBalancerPersistenceTypeAdapter());
            bindings.put(LoadBalancerType.class, new CustomDeserializers.LoadBalancerTypeAdapter());
            bindings.put(IpState.class, new CustomDeserializers.IpStateAdapter());
            return bindings;
        }
    }});

    @Test
    public void testApplyInputStreamDetails() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_get_load_balancer_list.json");
        ParseLoadBalancerListFromJsonResponse parser = (ParseLoadBalancerListFromJsonResponse)this.i.getInstance(ParseLoadBalancerListFromJsonResponse.class);
        SortedSet response = parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        Option dc = new Option(Long.valueOf(1L), "US-West-1", "US West 1 Datacenter");
        LoadBalancer loadBalancer = new LoadBalancer(6372L, "Balancer", null, new IpPortPair(new Ip(1313082L, "204.51.240.181", "204.51.240.176/255.255.255.240", true, IpState.ASSIGNED, dc), 80), (Set)ImmutableSortedSet.of((Comparable)new IpPortPair(new Ip(1313086L, "204.51.240.185", "204.51.240.176/255.255.255.240", true, IpState.ASSIGNED, dc), 80), (Comparable)new IpPortPair(new Ip(1313089L, "204.51.240.188", "204.51.240.176/255.255.255.240", true, IpState.ASSIGNED, dc), 80)), LoadBalancerType.ROUND_ROBIN, LoadBalancerPersistenceType.NONE, LoadBalancerOs.F5, LoadBalancerState.ON, dc);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)response), (Object)loadBalancer);
    }
}

