/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.functions;

import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.gogrid.config.DateSecondsAdapter;
import org.jclouds.gogrid.domain.IpState;
import org.jclouds.gogrid.domain.ServerImageState;
import org.jclouds.gogrid.domain.ServerImageType;
import org.jclouds.gogrid.domain.ServerState;
import org.jclouds.gogrid.functions.ParseServerNameToCredentialsMapFromJsonResponse;
import org.jclouds.gogrid.functions.internal.CustomDeserializers;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="gogrid.ParseServerNameToCredentialsMapFromJsonResponseTest")
public class ParseServerNameToCredentialsMapFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule(){

        protected void configure() {
            this.bind(GsonModule.DateAdapter.class).to(DateSecondsAdapter.class);
            super.configure();
        }

        @Provides
        @Singleton
        @Named(value="jclouds.gson-adapters")
        public Map<Type, Object> provideCustomAdapterBindings() {
            HashMap bindings = Maps.newHashMap();
            bindings.put(IpState.class, new CustomDeserializers.IpStateAdapter());
            bindings.put(ServerImageType.class, new CustomDeserializers.ServerImageTypeAdapter());
            bindings.put(ServerImageState.class, new CustomDeserializers.ServerImageStateAdapter());
            bindings.put(ServerState.class, new CustomDeserializers.ServerStateAdapter());
            return bindings;
        }
    }});

    @Test
    public void testApplyInputStreamDetails() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_credentials_list.json");
        ParseServerNameToCredentialsMapFromJsonResponse parser = (ParseServerNameToCredentialsMapFromJsonResponse)this.i.getInstance(ParseServerNameToCredentialsMapFromJsonResponse.class);
        Map response = parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        Assert.assertEquals((int)response.size(), (int)6);
    }
}

