/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.functions;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.inject.Singleton;
import org.jclouds.gogrid.config.GoGridParserModule;
import org.jclouds.gogrid.domain.BillingToken;
import org.jclouds.gogrid.domain.Customer;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.IpState;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.domain.ServerImageState;
import org.jclouds.gogrid.domain.ServerImageType;
import org.jclouds.gogrid.domain.ServerState;
import org.jclouds.gogrid.functions.ParseServerListFromJsonResponse;
import org.jclouds.gogrid.functions.internal.CustomDeserializers;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="gogrid.ParseServersFromJsonResponseTest")
public class ParseServersFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule(){

        protected void configure() {
            this.install((Module)new GoGridParserModule());
            super.configure();
        }

        @Provides
        @Singleton
        @Named(value="jclouds.gson-adapters")
        public Map<Class, Object> provideCustomAdapterBindings() {
            HashMap bindings = Maps.newHashMap();
            bindings.put(IpState.class, new CustomDeserializers.IpStateAdapter());
            bindings.put(ServerImageType.class, new CustomDeserializers.ServerImageTypeAdapter());
            bindings.put(ServerImageState.class, new CustomDeserializers.ServerImageStateAdapter());
            return bindings;
        }
    }});

    @Test
    public void testApplyInputStreamDetails() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_get_server_list.json");
        ParseServerListFromJsonResponse parser = (ParseServerListFromJsonResponse)this.i.getInstance(ParseServerListFromJsonResponse.class);
        SortedSet response = parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        Option dc = new Option(Long.valueOf(1L), "US-West-1", "US West 1 Datacenter");
        Option centOs = new Option(Long.valueOf(13L), "CentOS 5.2 (32-bit)", "CentOS 5.2 (32-bit)");
        Option webServer = new Option(Long.valueOf(1L), "Web Server", "Web or Application Server");
        Server server = new Server(75245L, dc, false, "PowerServer", "server to test the api. created by Alex", ServerState.ON, webServer, new Option(Long.valueOf(1L), "512MB", "Server with 512MB RAM"), centOs, new Ip(1313079L, "204.51.240.178", "204.51.240.176/255.255.255.240", true, IpState.ASSIGNED, dc), new ServerImage(1946L, "GSI-f8979644-e646-4711-ad58-d98a5fa3612c", "BitNami Gallery 2.3.1-0", "http://bitnami.org/stack/gallery", centOs, null, ServerImageType.WEB_APPLICATION_SERVER, ServerImageState.AVAILABLE, 0.0, "24732/GSI-f8979644-e646-4711-ad58-d98a5fa3612c.img", true, true, new Date(1261504577971L), new Date(1262649582180L), (Set)ImmutableSortedSet.of((Comparable)new BillingToken(38L, "CentOS 5.2 32bit", 0.0), (Comparable)new BillingToken(56L, "BitNami: Gallery", 0.0)), new Customer(24732L, "BitRock")));
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)response), (Object)server);
    }
}

