/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.services;

import com.google.common.collect.Iterables;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import org.jclouds.gogrid.domain.ServerImageState;
import org.jclouds.gogrid.domain.ServerImageType;
import org.jclouds.gogrid.functions.ParseImageFromJsonResponse;
import org.jclouds.gogrid.functions.ParseImageListFromJsonResponse;
import org.jclouds.gogrid.options.GetImageListOptions;
import org.jclouds.gogrid.services.BaseGoGridAsyncClientTest;
import org.jclouds.gogrid.services.GridImageAsyncClient;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.annotations.Test;

public class GridImageAsyncClientTest
extends BaseGoGridAsyncClientTest<GridImageAsyncClient> {
    @Test
    public void testGetImageListWithOptions() throws NoSuchMethodException, IOException {
        Method method = GridImageAsyncClient.class.getMethod("getImageList", GetImageListOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{new GetImageListOptions().onlyPublic().setState(ServerImageState.AVAILABLE).setType(ServerImageType.WEB_APPLICATION_SERVER)});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/list?v=1.5&isPublic=true&image.state=Available&image.type=Web%20Server HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseImageListFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/list?v=1.5&isPublic=true&image.state=Available&image.type=Web%20Server&sig=3f446f171455fbb5574aecff4997b273&api_key=foo HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testGetImagesByName() throws NoSuchMethodException, IOException {
        Method method = GridImageAsyncClient.class.getMethod("getImagesByName", String[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"name1", "name2"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/get?v=1.5&name=name1&name=name2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseImageListFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/get?v=1.5&name=name1&name=name2&sig=3f446f171455fbb5574aecff4997b273&api_key=foo HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testEditImageDescription() throws NoSuchMethodException, IOException {
        Method method = GridImageAsyncClient.class.getMethod("editImageDescription", String.class, String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"imageName", "newDesc"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/edit?v=1.5&image=imageName&description=newDesc HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseImageFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/edit?v=1.5&image=imageName&description=newDesc&sig=3f446f171455fbb5574aecff4997b273&api_key=foo HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testEditImageFriendlyName() throws NoSuchMethodException, IOException {
        Method method = GridImageAsyncClient.class.getMethod("editImageFriendlyName", String.class, String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"imageName", "newFriendlyName"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/edit?v=1.5&image=imageName&friendlyName=newFriendlyName HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseImageFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/edit?v=1.5&image=imageName&friendlyName=newFriendlyName&sig=3f446f171455fbb5574aecff4997b273&api_key=foo HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    protected TypeLiteral<RestAnnotationProcessor<GridImageAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<GridImageAsyncClient>>(){};
    }
}

