/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.services;

import com.google.common.collect.Iterables;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import org.jclouds.gogrid.domain.JobState;
import org.jclouds.gogrid.domain.ObjectType;
import org.jclouds.gogrid.functions.ParseJobListFromJsonResponse;
import org.jclouds.gogrid.options.GetJobListOptions;
import org.jclouds.gogrid.services.BaseGoGridAsyncClientTest;
import org.jclouds.gogrid.services.GridJobAsyncClient;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.annotations.Test;

public class GridJobAsyncClientTest
extends BaseGoGridAsyncClientTest<GridJobAsyncClient> {
    @Test
    public void testGetJobListWithOptions() throws NoSuchMethodException, IOException {
        Method method = GridJobAsyncClient.class.getMethod("getJobList", GetJobListOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{new GetJobListOptions.Builder().create().withStartDate(new Date(1267385381770L)).withEndDate(new Date(1267385382770L)).onlyForObjectType(ObjectType.VIRTUAL_SERVER).onlyForState(JobState.PROCESSING)});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/job/list?v=1.5&startdate=1267385381770&enddate=1267385382770&job.objecttype=VirtualServer&job.state=Processing HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseJobListFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/job/list?v=1.5&startdate=1267385381770&enddate=1267385382770&job.objecttype=VirtualServer&job.state=Processing&sig=3f446f171455fbb5574aecff4997b273&api_key=foo HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testGetJobListNoOptions() throws NoSuchMethodException, IOException {
        Method method = GridJobAsyncClient.class.getMethod("getJobList", GetJobListOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/job/list?v=1.5 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testGetJobsForServerName() throws NoSuchMethodException, IOException {
        Method method = GridJobAsyncClient.class.getMethod("getJobsForObjectName", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"MyServer"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/job/list?v=1.5&object=MyServer HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseJobListFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/job/list?v=1.5&object=MyServer&sig=3f446f171455fbb5574aecff4997b273&api_key=foo HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testGetJobsById() throws NoSuchMethodException, IOException {
        Method method = GridJobAsyncClient.class.getMethod("getJobsById", long[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{123L, 456L});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/job/get?v=1.5&id=123&id=456 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseJobListFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/job/get?v=1.5&id=123&id=456&sig=3f446f171455fbb5574aecff4997b273&api_key=foo HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    protected TypeLiteral<RestAnnotationProcessor<GridJobAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<GridJobAsyncClient>>(){};
    }
}

