/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.services;

import com.google.common.collect.Iterables;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.gogrid.domain.LoadBalancerPersistenceType;
import org.jclouds.gogrid.domain.LoadBalancerType;
import org.jclouds.gogrid.functions.ParseLoadBalancerFromJsonResponse;
import org.jclouds.gogrid.functions.ParseLoadBalancerListFromJsonResponse;
import org.jclouds.gogrid.options.AddLoadBalancerOptions;
import org.jclouds.gogrid.services.BaseGoGridAsyncClientTest;
import org.jclouds.gogrid.services.GridLoadBalancerAsyncClient;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.annotations.Test;

public class GridLoadBalancerAsyncClientTest
extends BaseGoGridAsyncClientTest<GridLoadBalancerAsyncClient> {
    @Test
    public void testGetLoadBalancerList() throws NoSuchMethodException, IOException {
        Method method = GridLoadBalancerAsyncClient.class.getMethod("getLoadBalancerList", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/list?v=1.5 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseLoadBalancerListFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/list?v=1.5&sig=3f446f171455fbb5574aecff4997b273&api_key=foo HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testAddLoadBalancer() throws NoSuchMethodException, IOException {
        Method method = GridLoadBalancerAsyncClient.class.getMethod("addLoadBalancer", String.class, IpPortPair.class, List.class, AddLoadBalancerOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"BalanceIt", new IpPortPair(new Ip("127.0.0.1"), 80), Arrays.asList(new IpPortPair(new Ip("127.0.0.1"), 8080), new IpPortPair(new Ip("127.0.0.1"), 9090)), new AddLoadBalancerOptions.Builder().create(LoadBalancerType.LEAST_CONNECTED, LoadBalancerPersistenceType.SSL_STICKY)});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/add?v=1.5&name=BalanceIt&loadbalancer.type=Least%20Connect&loadbalancer.persistence=SSL%20Sticky&realiplist.0.ip=127.0.0.1&realiplist.0.port=8080&realiplist.1.ip=127.0.0.1&realiplist.1.port=9090&virtualip.ip=127.0.0.1&virtualip.port=80 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseLoadBalancerFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/add?v=1.5&name=BalanceIt&loadbalancer.type=Least%20Connect&loadbalancer.persistence=SSL%20Sticky&realiplist.0.ip=127.0.0.1&realiplist.0.port=8080&realiplist.1.ip=127.0.0.1&realiplist.1.port=9090&virtualip.ip=127.0.0.1&virtualip.port=80&sig=3f446f171455fbb5574aecff4997b273&api_key=foo HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testEditLoadBalancer() throws NoSuchMethodException, IOException {
        Method method = GridLoadBalancerAsyncClient.class.getMethod("editLoadBalancer", Long.TYPE, List.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{1L, Arrays.asList(new IpPortPair(new Ip("127.0.0.1"), 8080), new IpPortPair(new Ip("127.0.0.1"), 9090))});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/edit?v=1.5&id=1&realiplist.0.ip=127.0.0.1&realiplist.0.port=8080&realiplist.1.ip=127.0.0.1&realiplist.1.port=9090 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseLoadBalancerFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/edit?v=1.5&id=1&realiplist.0.ip=127.0.0.1&realiplist.0.port=8080&realiplist.1.ip=127.0.0.1&realiplist.1.port=9090&sig=3f446f171455fbb5574aecff4997b273&api_key=foo HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testEditLoadBalancerNamed() throws NoSuchMethodException, IOException {
        Method method = GridLoadBalancerAsyncClient.class.getMethod("editLoadBalancerNamed", String.class, List.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"BalanceIt", Arrays.asList(new IpPortPair(new Ip("127.0.0.1"), 8080), new IpPortPair(new Ip("127.0.0.1"), 9090))});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/edit?v=1.5&name=BalanceIt&realiplist.0.ip=127.0.0.1&realiplist.0.port=8080&realiplist.1.ip=127.0.0.1&realiplist.1.port=9090 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseLoadBalancerFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/edit?v=1.5&name=BalanceIt&realiplist.0.ip=127.0.0.1&realiplist.0.port=8080&realiplist.1.ip=127.0.0.1&realiplist.1.port=9090&sig=3f446f171455fbb5574aecff4997b273&api_key=foo HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testGetLoadBalancersByName() throws NoSuchMethodException, IOException {
        Method method = GridLoadBalancerAsyncClient.class.getMethod("getLoadBalancersByName", String[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"My Load Balancer", "My Load Balancer 2"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/get?v=1.5&name=My%20Load%20Balancer&name=My%20Load%20Balancer%202 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseLoadBalancerListFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/get?v=1.5&name=My%20Load%20Balancer&name=My%20Load%20Balancer%202&sig=3f446f171455fbb5574aecff4997b273&api_key=foo HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testDeleteLoadBalancerById() throws NoSuchMethodException, IOException {
        Method method = GridLoadBalancerAsyncClient.class.getMethod("deleteById", Long.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{55L});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/delete?v=1.5&id=55 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ParseLoadBalancerFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/delete?v=1.5&id=55&sig=3f446f171455fbb5574aecff4997b273&api_key=foo HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    protected TypeLiteral<RestAnnotationProcessor<GridLoadBalancerAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<GridLoadBalancerAsyncClient>>(){};
    }
}

