/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.binders;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.Binder;

public class BindRealIpPortPairsToQueryParams
implements Binder {
    private final Provider<UriBuilder> builder;

    @Inject
    BindRealIpPortPairsToQueryParams(Provider<UriBuilder> builder) {
        this.builder = builder;
    }

    public void bindToRequest(HttpRequest request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input is null") instanceof List), (Object)"this binder is only valid for a List argument");
        List ipPortPairs = (List)input;
        int i = 0;
        for (IpPortPair ipPortPair : ipPortPairs) {
            Preconditions.checkNotNull((Object)ipPortPair.getIp(), (Object)"There must be an IP address defined");
            Preconditions.checkNotNull((Object)ipPortPair.getIp().getIp(), (Object)"There must be an IP address defined in Ip object");
            Preconditions.checkState((ipPortPair.getPort() > 0 ? 1 : 0) != 0, (Object)"The port number must be a positive integer");
            HttpUtils.addQueryParamTo((HttpRequest)request, (String)("realiplist." + i + ".ip"), (Object)ipPortPair.getIp().getIp(), (UriBuilder)((UriBuilder)this.builder.get()));
            HttpUtils.addQueryParamTo((HttpRequest)request, (String)("realiplist." + i + ".port"), (Object)String.valueOf(ipPortPair.getPort()), (UriBuilder)((UriBuilder)this.builder.get()));
            ++i;
        }
    }
}

