/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.binders;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.Binder;

public class BindVirtualIpPortPairToQueryParams
implements Binder {
    private final Provider<UriBuilder> builder;

    @Inject
    BindVirtualIpPortPairToQueryParams(Provider<UriBuilder> builder) {
        this.builder = builder;
    }

    public void bindToRequest(HttpRequest request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input is null") instanceof IpPortPair), (Object)"this binder is only valid for a IpPortPair argument");
        IpPortPair ipPortPair = (IpPortPair)input;
        Preconditions.checkNotNull((Object)ipPortPair.getIp(), (Object)"There must be an IP address defined");
        Preconditions.checkNotNull((Object)ipPortPair.getIp().getIp(), (Object)"There must be an IP address defined in Ip object");
        Preconditions.checkState((ipPortPair.getPort() > 0 ? 1 : 0) != 0, (Object)"The port number must be a positive integer");
        HttpUtils.addQueryParamTo((HttpRequest)request, (String)"virtualip.ip", (Object)ipPortPair.getIp().getIp(), (UriBuilder)((UriBuilder)this.builder.get()));
        HttpUtils.addQueryParamTo((HttpRequest)request, (String)"virtualip.port", (Object)String.valueOf(ipPortPair.getPort()), (UriBuilder)((UriBuilder)this.builder.get()));
    }
}

