/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.LoadBalancerService;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.config.ComputeServiceTimeoutsModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.internal.ComputeServiceContextImpl;
import org.jclouds.compute.strategy.AddNodeWithTagStrategy;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.gogrid.GoGridAsyncClient;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.compute.functions.ServerToNodeMetadata;
import org.jclouds.gogrid.compute.strategy.GoGridAddNodeWithTagStrategy;
import org.jclouds.gogrid.compute.strategy.GoGridDestroyNodeStrategy;
import org.jclouds.gogrid.compute.strategy.GoGridGetNodeMetadataStrategy;
import org.jclouds.gogrid.compute.strategy.GoGridListNodesStrategy;
import org.jclouds.gogrid.compute.strategy.GoGridRebootNodeStrategy;
import org.jclouds.gogrid.compute.suppliers.GoGridHardwareSupplier;
import org.jclouds.gogrid.compute.suppliers.GoGridImageSupplier;
import org.jclouds.gogrid.compute.suppliers.GoGridLocationSupplier;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.domain.ServerState;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.RestContextImpl;

public class GoGridComputeServiceContextModule
extends BaseComputeServiceContextModule {
    @VisibleForTesting
    static final Map<ServerState, NodeState> serverStateToNodeState = ImmutableMap.builder().put((Object)ServerState.ON, (Object)NodeState.RUNNING).put((Object)ServerState.STARTING, (Object)NodeState.PENDING).put((Object)ServerState.OFF, (Object)NodeState.SUSPENDED).put((Object)ServerState.STOPPING, (Object)NodeState.PENDING).put((Object)ServerState.RESTARTING, (Object)NodeState.PENDING).put((Object)ServerState.SAVING, (Object)NodeState.PENDING).put((Object)ServerState.UNRECOGNIZED, (Object)NodeState.UNRECOGNIZED).put((Object)ServerState.RESTORING, (Object)NodeState.PENDING).put((Object)ServerState.UPDATING, (Object)NodeState.PENDING).build();

    protected void configure() {
        this.install((Module)new ComputeServiceTimeoutsModule());
        this.bind((TypeLiteral)new TypeLiteral<Function<Server, NodeMetadata>>(){}).to(ServerToNodeMetadata.class);
        this.bind(LoadBalancerService.class).toProvider(Providers.of(null));
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceContext>(){}).to((TypeLiteral)new TypeLiteral<ComputeServiceContextImpl<GoGridClient, GoGridAsyncClient>>(){}).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<RestContext<GoGridClient, GoGridAsyncClient>>(){}).to((TypeLiteral)new TypeLiteral<RestContextImpl<GoGridClient, GoGridAsyncClient>>(){}).in(Scopes.SINGLETON);
        this.bind(AddNodeWithTagStrategy.class).to(GoGridAddNodeWithTagStrategy.class);
        this.bind(ListNodesStrategy.class).to(GoGridListNodesStrategy.class);
        this.bind(GetNodeMetadataStrategy.class).to(GoGridGetNodeMetadataStrategy.class);
        this.bind(RebootNodeStrategy.class).to(GoGridRebootNodeStrategy.class);
        this.bind(DestroyNodeStrategy.class).to(GoGridDestroyNodeStrategy.class);
    }

    protected TemplateBuilder provideTemplate(Injector injector, TemplateBuilder template) {
        return template.osFamily(OsFamily.CENTOS).imageNameMatches(".*w/ None.*");
    }

    @Singleton
    @Provides
    Map<ServerState, NodeState> provideServerToNodeState() {
        return serverStateToNodeState;
    }

    @Singleton
    @Provides
    Function<Hardware, String> provideSizeToRam() {
        return new Function<Hardware, String>(){

            public String apply(Hardware hardware) {
                if (hardware.getRam() >= 8192 || ComputeServiceUtils.getCores((Hardware)hardware) >= 6.0 || ComputeServiceUtils.getSpace((Hardware)hardware) >= 450.0) {
                    return "8GB";
                }
                if (hardware.getRam() >= 4096 || ComputeServiceUtils.getCores((Hardware)hardware) >= 3.0 || ComputeServiceUtils.getSpace((Hardware)hardware) >= 230.0) {
                    return "4GB";
                }
                if (hardware.getRam() >= 2048 || ComputeServiceUtils.getSpace((Hardware)hardware) >= 110.0) {
                    return "2GB";
                }
                if (hardware.getRam() >= 1024 || ComputeServiceUtils.getSpace((Hardware)hardware) >= 55.0) {
                    return "1GB";
                }
                return "512MB";
            }
        };
    }

    protected Supplier<Location> supplyDefaultLocation(Injector injector, Supplier<Set<? extends Location>> locations) {
        final String defaultDC = (String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"jclouds.gogrid.defaultdc")));
        return Suppliers.compose((Function)new Function<Set<? extends Location>, Location>(){

            public Location apply(Set<? extends Location> from) {
                return (Location)Iterables.find(from, (Predicate)new Predicate<Location>(){

                    public boolean apply(Location input) {
                        return input.getId().equals(defaultDC);
                    }
                });
            }
        }, locations);
    }

    protected Supplier<Set<? extends Image>> getSourceImageSupplier(Injector injector) {
        return (Supplier)injector.getInstance(GoGridImageSupplier.class);
    }

    protected Supplier<Set<? extends Location>> getSourceLocationSupplier(Injector injector) {
        return (Supplier)injector.getInstance(GoGridLocationSupplier.class);
    }

    protected Supplier<Set<? extends Hardware>> getSourceSizeSupplier(Injector injector) {
        return (Supplier)injector.getInstance(GoGridHardwareSupplier.class);
    }
}

