/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.internal.NodeMetadataImpl;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.domain.ServerState;
import org.jclouds.logging.Logger;

@Singleton
public class ServerToNodeMetadata
implements Function<Server, NodeMetadata> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Map<ServerState, NodeState> serverStateToNodeState;
    private final GoGridClient client;
    private final Supplier<Set<? extends Image>> images;
    private final Supplier<Set<? extends Hardware>> hardwares;
    private final Supplier<Map<String, ? extends Location>> locations;

    @Inject
    ServerToNodeMetadata(Map<ServerState, NodeState> serverStateToNodeState, GoGridClient client, Supplier<Set<? extends Image>> images, Supplier<Set<? extends Hardware>> hardwares, Supplier<Map<String, ? extends Location>> locations) {
        this.serverStateToNodeState = (Map)Preconditions.checkNotNull(serverStateToNodeState, (Object)"serverStateToNodeState");
        this.client = (GoGridClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images");
        this.hardwares = (Supplier)Preconditions.checkNotNull(hardwares, (Object)"hardwares");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
    }

    public NodeMetadata apply(Server from) {
        String tag = ComputeServiceUtils.parseTagFromName((String)from.getName());
        ImmutableSet ipSet = ImmutableSet.of((Object)from.getIp().getIp());
        NodeState state = this.serverStateToNodeState.get((Object)from.getState());
        Credentials creds = this.client.getServerServices().getServerCredentialsList().get(from.getName());
        Image image = null;
        try {
            image = (Image)Iterables.find((Iterable)((Iterable)this.images.get()), (Predicate)new FindImageForServer(from));
        }
        catch (NoSuchElementException e) {
            this.logger.warn("could not find a matching image for server %s", new Object[]{from});
        }
        Hardware hardware = null;
        try {
            hardware = (Hardware)Iterables.find((Iterable)((Iterable)this.hardwares.get()), (Predicate)new FindHardwareForServer(from));
        }
        catch (NoSuchElementException e) {
            this.logger.warn("could not find a matching hardware for server %s", new Object[]{from});
        }
        return new NodeMetadataImpl(from.getId() + "", from.getName(), from.getId() + "", (Location)((Map)this.locations.get()).get(from.getDatacenter().getId() + ""), null, (Map)ImmutableMap.of(), tag, hardware, from.getImage().getId() + "", image != null ? image.getOperatingSystem() : null, state, (Iterable)ipSet, (Iterable)ImmutableList.of(), creds);
    }

    static class FindHardwareForServer
    implements Predicate<Hardware> {
        private final Server instance;

        @Inject
        private FindHardwareForServer(Server instance) {
            this.instance = instance;
        }

        public boolean apply(Hardware input) {
            return input.getRam() == Integer.parseInt(this.instance.getRam().getName().replaceAll("[^0-9]", ""));
        }
    }

    static class FindImageForServer
    implements Predicate<Image> {
        private final Server instance;

        @Inject
        private FindImageForServer(Server instance) {
            this.instance = instance;
        }

        public boolean apply(Image input) {
            return input.getProviderId().equals(this.instance.getImage().getId() + "") && (input.getLocation() == null || input.getLocation().getId().equals(this.instance.getDatacenter().getId() + ""));
        }
    }
}

