/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.security.SecureRandom;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.AddNodeWithTagStrategy;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.IpType;
import org.jclouds.gogrid.domain.PowerCommand;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.options.AddServerOptions;
import org.jclouds.gogrid.options.GetIpListOptions;
import org.jclouds.gogrid.predicates.ServerLatestJobCompleted;
import org.jclouds.predicates.RetryablePredicate;

@Singleton
public class GoGridAddNodeWithTagStrategy
implements AddNodeWithTagStrategy {
    private final GoGridClient client;
    private final Function<Hardware, String> sizeToRam;
    private final Function<Server, NodeMetadata> serverToNodeMetadata;
    private RetryablePredicate<Server> serverLatestJobCompleted;
    private RetryablePredicate<Server> serverLatestJobCompletedShort;

    @Inject
    protected GoGridAddNodeWithTagStrategy(GoGridClient client, Function<Server, NodeMetadata> serverToNodeMetadata, Function<Hardware, String> sizeToRam, ComputeServiceConstants.Timeouts timeouts) {
        this.client = client;
        this.serverToNodeMetadata = serverToNodeMetadata;
        this.sizeToRam = sizeToRam;
        this.serverLatestJobCompleted = new RetryablePredicate((Predicate)new ServerLatestJobCompleted(client.getJobServices()), timeouts.nodeRunning * 9L / 10L);
        this.serverLatestJobCompletedShort = new RetryablePredicate((Predicate)new ServerLatestJobCompleted(client.getJobServices()), timeouts.nodeRunning * 1L / 10L);
    }

    public NodeMetadata execute(String tag, String name, Template template) {
        Server addedServer = null;
        boolean notStarted = true;
        int numOfRetries = 20;
        while (notStarted) {
            Set<Ip> availableIps = this.client.getIpServices().getIpList(new GetIpListOptions().onlyUnassigned().onlyWithType(IpType.PUBLIC).inDatacenter(template.getLocation().getId()));
            if (availableIps.size() == 0) {
                throw new RuntimeException("No public IPs available on this identity.");
            }
            int ipIndex = new SecureRandom().nextInt(availableIps.size());
            Ip availableIp = (Ip)Iterables.get(availableIps, (int)ipIndex);
            try {
                addedServer = this.addServer(name, template, availableIp);
                notStarted = false;
            }
            catch (Exception e) {
                if (--numOfRetries == 0) {
                    Throwables.propagate((Throwable)e);
                }
                notStarted = true;
            }
        }
        if (template.getOptions().shouldBlockUntilRunning()) {
            this.serverLatestJobCompleted.apply(addedServer);
            this.client.getServerServices().power(addedServer.getName(), PowerCommand.START);
            this.serverLatestJobCompletedShort.apply((Object)addedServer);
            addedServer = (Server)Iterables.getOnlyElement(this.client.getServerServices().getServersByName(addedServer.getName()));
        }
        return (NodeMetadata)this.serverToNodeMetadata.apply(addedServer);
    }

    private Server addServer(String name, Template template, Ip availableIp) {
        Server addedServer = this.client.getServerServices().addServer(name, (String)Preconditions.checkNotNull((Object)template.getImage().getProviderId()), (String)this.sizeToRam.apply((Object)template.getHardware()), availableIp.getIp(), new AddServerOptions[0]);
        return addedServer;
    }
}

