/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.domain.Server;

@Singleton
public class GoGridGetNodeMetadataStrategy
implements GetNodeMetadataStrategy {
    private final GoGridClient client;
    private final Function<Server, NodeMetadata> serverToNodeMetadata;

    @Inject
    protected GoGridGetNodeMetadataStrategy(GoGridClient client, Function<Server, NodeMetadata> serverToNodeMetadata) {
        this.client = client;
        this.serverToNodeMetadata = serverToNodeMetadata;
    }

    public NodeMetadata execute(String id) {
        try {
            Server server = (Server)Iterables.getOnlyElement(this.client.getServerServices().getServersById(new Long((String)Preconditions.checkNotNull((Object)id, (Object)"id"))));
            return server == null ? null : (NodeMetadata)this.serverToNodeMetadata.apply((Object)server);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

