/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.options.GetServerListOptions;

@Singleton
public class GoGridListNodesStrategy
implements ListNodesStrategy {
    private final GoGridClient client;
    private final Function<Server, NodeMetadata> serverToNodeMetadata;

    @Inject
    protected GoGridListNodesStrategy(GoGridClient client, Function<Server, NodeMetadata> serverToNodeMetadata) {
        this.client = client;
        this.serverToNodeMetadata = serverToNodeMetadata;
    }

    public Iterable<? extends ComputeMetadata> list() {
        return this.listDetailsOnNodesMatching((Predicate<ComputeMetadata>)NodePredicates.all());
    }

    public Iterable<? extends NodeMetadata> listDetailsOnNodesMatching(Predicate<ComputeMetadata> filter) {
        return Iterables.filter((Iterable)Iterables.transform(this.client.getServerServices().getServerList(new GetServerListOptions[0]), this.serverToNodeMetadata), filter);
    }
}

