/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.strategy;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.domain.PowerCommand;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.predicates.ServerLatestJobCompleted;
import org.jclouds.predicates.RetryablePredicate;

@Singleton
public class GoGridRebootNodeStrategy
implements RebootNodeStrategy {
    private final GoGridClient client;
    private final RetryablePredicate<Server> serverLatestJobCompleted;
    private final RetryablePredicate<Server> serverLatestJobCompletedShort;
    private final GetNodeMetadataStrategy getNode;

    @Inject
    protected GoGridRebootNodeStrategy(GoGridClient client, GetNodeMetadataStrategy getNode, ComputeServiceConstants.Timeouts timeouts) {
        this.client = client;
        this.serverLatestJobCompleted = new RetryablePredicate((Predicate)new ServerLatestJobCompleted(client.getJobServices()), timeouts.nodeRunning * 9L / 10L);
        this.serverLatestJobCompletedShort = new RetryablePredicate((Predicate)new ServerLatestJobCompleted(client.getJobServices()), timeouts.nodeRunning * 1L / 10L);
        this.getNode = getNode;
    }

    public NodeMetadata execute(String id) {
        Server server = (Server)Iterables.getOnlyElement(this.client.getServerServices().getServersById(new Long(id)));
        this.client.getServerServices().power(server.getName(), PowerCommand.RESTART);
        this.serverLatestJobCompleted.apply((Object)server);
        this.client.getServerServices().power(server.getName(), PowerCommand.START);
        this.serverLatestJobCompletedShort.apply((Object)server);
        return this.getNode.execute(id);
    }
}

