/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.suppliers;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.internal.ImageImpl;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.options.GetImageListOptions;
import org.jclouds.gogrid.util.GoGridUtils;
import org.jclouds.logging.Logger;

@Singleton
public class GoGridImageSupplier
implements Supplier<Set<? extends Image>> {
    public static final Pattern GOGRID_OS_NAME_PATTERN = Pattern.compile("([a-zA-Z]*)(.*)");
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final GoGridClient sync;
    private final PopulateDefaultLoginCredentialsForImageStrategy authenticator;

    @Inject
    GoGridImageSupplier(GoGridClient sync, PopulateDefaultLoginCredentialsForImageStrategy authenticator) {
        this.sync = sync;
        this.authenticator = authenticator;
    }

    public Set<? extends Image> get() {
        HashSet images = Sets.newHashSet();
        this.logger.debug(">> providing images", new Object[0]);
        Set<ServerImage> allImages = this.sync.getImageServices().getImageList(new GetImageListOptions[0]);
        for (ServerImage from : allImages) {
            OsFamily osFamily = null;
            String osName = from.getOs().getName();
            String osArch = from.getArchitecture().getDescription();
            String osVersion = null;
            String osDescription = from.getOs().getDescription();
            boolean is64Bit = from.getOs().getName().indexOf("64") != -1 || from.getDescription().indexOf("64") != -1;
            String description = from.getDescription();
            String version = "";
            String matchedOs = GoGridUtils.parseStringByPatternAndGetNthMatchGroup(osName, GOGRID_OS_NAME_PATTERN, 1);
            try {
                osFamily = OsFamily.fromValue((String)matchedOs.toLowerCase());
            }
            catch (IllegalArgumentException e) {
                this.logger.debug("<< didn't match os(%s)", new Object[]{matchedOs});
            }
            Credentials defaultCredentials = this.authenticator.execute((Object)from);
            OperatingSystem os = new OperatingSystem(osFamily, osName, osVersion, osArch, osDescription, is64Bit);
            images.add(new ImageImpl(from.getId() + "", from.getFriendlyName(), from.getId() + "", null, null, (Map)ImmutableMap.of(), os, description, version, defaultCredentials));
        }
        this.logger.debug("<< images(%d)", new Object[]{images.size()});
        return images;
    }
}

