/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.suppliers;

import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.internal.LocationImpl;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.Provider;

@Singleton
public class GoGridLocationSupplier
implements Supplier<Set<? extends Location>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final String providerName;
    private final GoGridClient sync;

    @Inject
    GoGridLocationSupplier(@Provider String providerName, GoGridClient sync) {
        this.providerName = providerName;
        this.sync = sync;
    }

    public Set<? extends Location> get() {
        HashSet locations = Sets.newHashSet();
        this.logger.debug(">> providing locations", new Object[0]);
        LocationImpl parent = new LocationImpl(LocationScope.PROVIDER, this.providerName, this.providerName, null);
        for (Option dc : this.sync.getServerServices().getDatacenters()) {
            locations.add(new LocationImpl(LocationScope.ZONE, dc.getId() + "", dc.getDescription(), (Location)parent));
        }
        this.logger.debug("<< locations(%d)", new Object[]{locations.size()});
        return locations;
    }
}

