/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.primitives.Longs;

public class BillingToken
implements Comparable<BillingToken> {
    private long id;
    private String name;
    private double price;

    public BillingToken() {
    }

    public BillingToken(long id, String name, double price) {
        this.id = id;
        this.name = name;
        this.price = price;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public double getPrice() {
        return this.price;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingToken that = (BillingToken)o;
        if (this.id != that.id) {
            return false;
        }
        if (Double.compare(that.price, this.price) != 0) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.name.hashCode();
        long temp = this.price != 0.0 ? Double.doubleToLongBits(this.price) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public int compareTo(BillingToken o) {
        return Longs.compare((long)this.id, (long)o.getId());
    }

    public String toString() {
        return "BillingToken{id=" + this.id + ", name='" + this.name + '\'' + ", price=" + this.price + '}';
    }
}

