/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import org.jclouds.gogrid.domain.Ip;

public class IpPortPair
implements Comparable<IpPortPair> {
    private Ip ip;
    private int port;

    public IpPortPair() {
    }

    public IpPortPair(Ip ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public Ip getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpPortPair that = (IpPortPair)o;
        if (this.port != that.port) {
            return false;
        }
        return !(this.ip != null ? !this.ip.equals(that.ip) : that.ip != null);
    }

    public int hashCode() {
        int result = this.ip != null ? this.ip.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }

    @Override
    public int compareTo(IpPortPair o) {
        if (this.ip != null && o.getIp() != null) {
            return Longs.compare((long)this.ip.getId(), (long)o.getIp().getId());
        }
        return Ints.compare((int)this.port, (int)o.getPort());
    }

    public String toString() {
        return "IpPortPair [ip=" + this.ip + ", port=" + this.port + "]";
    }
}

