/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.options;

import com.google.common.base.Preconditions;
import org.jclouds.gogrid.domain.ServerImageState;
import org.jclouds.gogrid.domain.ServerImageType;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class GetImageListOptions
extends BaseHttpRequestOptions {
    public GetImageListOptions setType(ServerImageType imageType) {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"image.type") ? 1 : 0) != 0, (Object)"Can't have duplicate image type restrictions");
        this.queryParameters.put((Object)"image.type", (Object)imageType.toString());
        return this;
    }

    public GetImageListOptions setState(ServerImageState imageState) {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"image.state") ? 1 : 0) != 0, (Object)"Can't have duplicate image state restrictions");
        this.queryParameters.put((Object)"image.state", (Object)imageState.toString());
        return this;
    }

    public GetImageListOptions onlyPublic() {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"isPublic") ? 1 : 0) != 0, (Object)"Can't have duplicate image visibility restrictions");
        this.queryParameters.put((Object)"isPublic", (Object)"true");
        return this;
    }

    public GetImageListOptions onlyPrivate() {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"isPublic") ? 1 : 0) != 0, (Object)"Can't have duplicate image visibility restrictions");
        this.queryParameters.put((Object)"isPublic", (Object)"false");
        return this;
    }

    public GetImageListOptions inDatacenter(String datacenterId) {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"datacenter") ? 1 : 0) != 0, (Object)"Can't have duplicate datacenter id");
        this.queryParameters.put((Object)"datacenter", (Object)datacenterId);
        return this;
    }

    public GetImageListOptions maxItemsNumber(Integer maxNumber) {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"num_items") ? 1 : 0) != 0, (Object)"Can't have duplicate parameter of max returned items");
        this.queryParameters.put((Object)"num_items", (Object)maxNumber.toString());
        return this;
    }

    public static class Builder {
        public GetImageListOptions inDatacenter(String datacenterId) {
            GetImageListOptions getImageListOptions = new GetImageListOptions();
            return getImageListOptions.inDatacenter((String)Preconditions.checkNotNull((Object)datacenterId));
        }

        public GetImageListOptions publicWebServers() {
            return new GetImageListOptions().setState(ServerImageState.AVAILABLE).setType(ServerImageType.WEB_APPLICATION_SERVER).onlyPublic();
        }

        public GetImageListOptions publicDatabaseServers() {
            return new GetImageListOptions().setState(ServerImageState.AVAILABLE).setType(ServerImageType.DATABASE_SERVER).onlyPublic();
        }
    }
}

