/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.gogrid.domain.Job;
import org.jclouds.gogrid.domain.JobState;
import org.jclouds.gogrid.domain.LoadBalancer;
import org.jclouds.gogrid.options.GetJobListOptions;
import org.jclouds.gogrid.services.GridJobClient;
import org.jclouds.logging.Logger;

@Singleton
public class LoadBalancerLatestJobCompleted
implements Predicate<LoadBalancer> {
    protected GridJobClient jobClient;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public LoadBalancerLatestJobCompleted(GridJobClient jobClient) {
        this.jobClient = jobClient;
    }

    public boolean apply(LoadBalancer loadBalancer) {
        Preconditions.checkNotNull((Object)loadBalancer, (Object)"Load balancer must be a valid instance");
        Preconditions.checkNotNull((Object)loadBalancer.getName(), (Object)"Load balancer must be a valid name");
        GetJobListOptions jobOptions = new GetJobListOptions.Builder().latestJobForObjectByName(loadBalancer.getName());
        Job latestJob = (Job)Iterables.getOnlyElement(this.jobClient.getJobList(jobOptions));
        return JobState.SUCCEEDED.equals((Object)latestJob.getCurrentState());
    }
}

