/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.filters.SharedKeyLiteAuthentication;
import org.jclouds.gogrid.functions.ParseImageFromJsonResponse;
import org.jclouds.gogrid.functions.ParseImageListFromJsonResponse;
import org.jclouds.gogrid.functions.ParseOptionsFromJsonResponse;
import org.jclouds.gogrid.options.GetImageListOptions;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={SharedKeyLiteAuthentication.class})
@QueryParams(keys={"v"}, values={"1.5"})
public interface GridImageAsyncClient {
    @GET
    @ResponseParser(value=ParseImageListFromJsonResponse.class)
    @Path(value="/grid/image/list")
    public ListenableFuture<Set<ServerImage>> getImageList(GetImageListOptions ... var1);

    @GET
    @ResponseParser(value=ParseImageListFromJsonResponse.class)
    @Path(value="/grid/image/get")
    public ListenableFuture<Set<ServerImage>> getImagesById(Long ... var1);

    @GET
    @ResponseParser(value=ParseImageListFromJsonResponse.class)
    @Path(value="/grid/image/get")
    public ListenableFuture<Set<ServerImage>> getImagesByName(String ... var1);

    @GET
    @ResponseParser(value=ParseImageFromJsonResponse.class)
    @Path(value="/grid/image/edit")
    public ListenableFuture<ServerImage> editImageDescription(@QueryParam(value="image") String var1, @QueryParam(value="description") String var2);

    @GET
    @ResponseParser(value=ParseImageFromJsonResponse.class)
    @Path(value="/grid/image/edit")
    public ListenableFuture<ServerImage> editImageFriendlyName(@QueryParam(value="image") String var1, @QueryParam(value="friendlyName") String var2);

    @GET
    @ResponseParser(value=ParseOptionsFromJsonResponse.class)
    @Path(value="/common/lookup/list")
    @QueryParams(keys={"lookup"}, values={"datacenter"})
    public ListenableFuture<Set<Option>> getDatacenters();
}

