/**
 *
 * Copyright (C) 2010 Cloud Conscious, LLC. <info@cloudconscious.com>
 *
 * ====================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ====================================================================
 */

package org.jclouds.vcloud.terremark.options;

import java.util.Map;

import org.jclouds.http.HttpRequest;
import org.jclouds.vcloud.terremark.binders.BindAddInternetServiceToXmlPayload;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;

/**
 * 
 * @author Adrian Cole
 * 
 */
public class AddInternetServiceOptions extends BindAddInternetServiceToXmlPayload {

   @VisibleForTesting
   String description = null;
   @VisibleForTesting
   String enabled = "true";

   public void bindToRequest(HttpRequest request, Map<String, String> postParams) {
      Map<String, String> copy = Maps.newHashMap();
      copy.putAll(postParams);
      copy.put("description", description);
      copy.put("enabled", enabled);
      super.bindToRequest(request, copy);
   }

   public AddInternetServiceOptions disabled() {
      this.enabled = "false";
      return this;
   }

   public AddInternetServiceOptions withDescription(String description) {
      this.description = description;
      return this;
   }

   public static class Builder {

      /**
       * @see AddInternetServiceOptions#withDescription(String)
       */
      public static AddInternetServiceOptions withDescription(String description) {
         AddInternetServiceOptions options = new AddInternetServiceOptions();
         return options.withDescription(description);
      }

      /**
       * @see AddInternetServiceOptions#disabled()
       */
      public static AddInternetServiceOptions disabled() {
         AddInternetServiceOptions options = new AddInternetServiceOptions();
         return options.disabled();
      }
   }
}
