/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jclouds.http.HttpResponseException;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.net.IPSocket;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.predicates.SocketOpen;
import org.jclouds.rest.RestContextFactory;
import org.jclouds.ssh.SshClient;
import org.jclouds.ssh.SshException;
import org.jclouds.ssh.jsch.config.JschSshClientModule;
import org.jclouds.vcloud.VCloudExpressClient;
import org.jclouds.vcloud.VCloudExpressClientLiveTest;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VCloudExpressVApp;
import org.jclouds.vcloud.domain.VCloudExpressVAppTemplate;
import org.jclouds.vcloud.domain.VDC;
import org.jclouds.vcloud.domain.ovf.ResourceAllocation;
import org.jclouds.vcloud.domain.ovf.ResourceType;
import org.jclouds.vcloud.options.CloneVAppOptions;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;
import org.jclouds.vcloud.predicates.TaskSuccess;
import org.jclouds.vcloud.predicates.VCloudPredicates;
import org.jclouds.vcloud.terremark.TerremarkECloudClient;
import org.jclouds.vcloud.terremark.TerremarkVCloudClient;
import org.jclouds.vcloud.terremark.TerremarkVCloudExpressClient;
import org.jclouds.vcloud.terremark.domain.CustomizationParameters;
import org.jclouds.vcloud.terremark.domain.InternetService;
import org.jclouds.vcloud.terremark.domain.Node;
import org.jclouds.vcloud.terremark.domain.Protocol;
import org.jclouds.vcloud.terremark.domain.PublicIpAddress;
import org.jclouds.vcloud.terremark.domain.TerremarkCatalogItem;
import org.jclouds.vcloud.terremark.domain.TerremarkVDC;
import org.jclouds.vcloud.terremark.domain.VAppConfiguration;
import org.jclouds.vcloud.terremark.options.AddInternetServiceOptions;
import org.jclouds.vcloud.terremark.options.AddNodeOptions;
import org.jclouds.vcloud.terremark.options.TerremarkInstantiateVAppTemplateOptions;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

public abstract class TerremarkClientLiveTest
extends VCloudExpressClientLiveTest {
    protected String expectedOs = "Ubuntu Linux (32-bit)";
    protected String itemName = "Ubuntu JeOS 9.10 (32-bit)";
    protected TerremarkVCloudClient tmClient;
    protected SshClient.Factory sshFactory;
    private String publicIp;
    private InternetService is;
    private Node node;
    private VCloudExpressVApp vApp;
    private RetryablePredicate<IPSocket> socketTester;
    private RetryablePredicate<URI> successTester;
    private VCloudExpressVApp clone;
    private VDC vdc;
    public static final String PREFIX = System.getProperty("user.name") + "-terremark";
    protected String provider = "trmk-vcloudexpress";
    protected String identity;
    protected String credential;
    protected String endpoint;
    protected String apiversion;

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testCatalog() throws Exception {
        super.testCatalog();
    }

    @Test
    public void testGetAllInternetServices() throws Exception {
        for (InternetService service : this.tmClient.getAllInternetServicesInVDC(this.tmClient.findVDCInOrgNamed(null, null).getHref())) {
            Assert.assertNotNull((Object)this.tmClient.getNodes(service.getId()));
        }
    }

    @Test
    public void testGetPublicIpsAssociatedWithVDC() throws Exception {
        for (PublicIpAddress ip : this.tmClient.getPublicIpsAssociatedWithVDC(this.tmClient.findVDCInOrgNamed(null, null).getHref())) {
            Assert.assertNotNull((Object)this.tmClient.getInternetServicesOnPublicIp(ip.getId()));
            Assert.assertNotNull((Object)this.tmClient.getPublicIp(ip.getId()));
        }
    }

    @Test
    public void testGetConfigCustomizationOptions() throws Exception {
        Catalog response = ((VCloudExpressClient)this.connection).findCatalogInOrgNamed(null, null);
        for (ReferenceType resource : response.values()) {
            if (!resource.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml")) continue;
            TerremarkCatalogItem item = this.tmClient.findCatalogItemInOrgCatalogNamed(null, null, resource.getName());
            assert (this.tmClient.getCustomizationOptions(item.getCustomizationOptions().getHref()) != null);
        }
    }

    @Test
    public void testDefaultVDC() throws Exception {
        super.testDefaultVDC();
        TerremarkVDC response = (TerremarkVDC)this.tmClient.findVDCInOrgNamed(null, null);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getCatalog());
        Assert.assertNotNull((Object)response.getInternetServices());
        Assert.assertNotNull((Object)response.getPublicIps());
    }

    @Test(enabled=true)
    public void testInstantiateAndPowerOn() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        this.prepare();
        StringBuffer name = new StringBuffer();
        for (int i = 0; i < 15; ++i) {
            name.append("a");
        }
        String serverName = name.toString();
        long hardDisk = 0x400000L;
        this.vdc = this.tmClient.findVDCInOrgNamed(null, null);
        TerremarkInstantiateVAppTemplateOptions instantiateOptions = this.createInstantiateOptions();
        TerremarkCatalogItem item = this.tmClient.findCatalogItemInOrgCatalogNamed(null, null, this.itemName);
        CustomizationParameters customizationOptions = this.tmClient.getCustomizationOptions(item.getCustomizationOptions().getHref());
        if (customizationOptions.canCustomizePassword()) {
            instantiateOptions.withPassword("robotsarefun");
        }
        VCloudExpressVAppTemplate vAppTemplate = this.tmClient.getVAppTemplate(item.getEntity().getHref());
        this.vApp = this.tmClient.instantiateVAppTemplateInVDC(this.vdc.getHref(), vAppTemplate.getHref(), serverName, new InstantiateVAppTemplateOptions[]{instantiateOptions});
        Assert.assertEquals((Object)this.vApp.getStatus(), (Object)Status.RESOLVED);
        Task deployTask = this.tmClient.deployVApp(this.vApp.getHref());
        deployTask = this.tmClient.deployVApp(this.vApp.getHref());
        Assert.assertEquals((Object)deployTask.getHref(), (Object)deployTask.getHref());
        this.vApp = this.tmClient.getVApp(this.vApp.getHref());
        Assert.assertEquals((Object)this.vApp.getStatus(), (Object)Status.RESOLVED);
        try {
            this.tmClient.cancelTask(deployTask.getHref());
        }
        catch (HttpResponseException e) {
            Assert.assertEquals((int)e.getResponse().getStatusCode(), (int)501);
        }
        assert (this.successTester.apply((Object)deployTask.getHref()));
        System.out.printf("%d: done deploying vApp%n", System.currentTimeMillis());
        this.vApp = this.tmClient.getVApp(this.vApp.getHref());
        ReferenceType vAppResource = (ReferenceType)this.tmClient.findVDCInOrgNamed(null, null).getResourceEntities().get(serverName);
        Assert.assertEquals((Object)vAppResource.getHref(), (Object)this.vApp.getHref());
        int processorCount = 1;
        long memory = 512L;
        this.verifyConfigurationOfVApp(this.vApp, serverName, this.expectedOs, processorCount, memory, hardDisk);
        Assert.assertEquals((Object)this.vApp.getStatus(), (Object)Status.OFF);
        assert (this.successTester.apply((Object)this.tmClient.powerOnVApp(this.vApp.getHref()).getHref()));
        System.out.printf("%d: done powering on vApp%n", System.currentTimeMillis());
        this.vApp = this.tmClient.getVApp(this.vApp.getHref());
        Assert.assertEquals((Object)this.vApp.getStatus(), (Object)Status.ON);
    }

    protected void prepare() {
    }

    abstract TerremarkInstantiateVAppTemplateOptions createInstantiateOptions();

    @Test
    public void testAddInternetService() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        PublicIpAddress ip;
        if (this.tmClient instanceof TerremarkVCloudExpressClient) {
            this.is = ((TerremarkVCloudExpressClient)TerremarkVCloudExpressClient.class.cast(this.tmClient)).addInternetServiceToVDC(this.tmClient.findVDCInOrgNamed(null, null).getHref(), "SSH", Protocol.TCP, 22, new AddInternetServiceOptions[0]);
            ip = this.is.getPublicIpAddress();
        } else {
            ip = ((TerremarkECloudClient)TerremarkECloudClient.class.cast(this.tmClient)).activatePublicIpInVDC(this.tmClient.findVDCInOrgNamed(null, null).getHref());
            this.is = this.tmClient.addInternetServiceToExistingIp(ip.getId(), "SSH", Protocol.TCP, 22, new AddInternetServiceOptions[0]);
        }
        this.publicIp = ip.getAddress();
    }

    @Test(enabled=true, dependsOnMethods={"testInstantiateAndPowerOn"})
    public void testCloneVApp() throws IOException {
        assert (this.successTester.apply((Object)this.tmClient.powerOffVApp(this.vApp.getHref()).getHref()));
        System.out.printf("%d: done powering off vApp%n", System.currentTimeMillis());
        StringBuffer name = new StringBuffer();
        for (int i = 0; i < 15; ++i) {
            name.append("b");
        }
        String newName = name.toString();
        CloneVAppOptions options = CloneVAppOptions.Builder.deploy().powerOn().withDescription("The description of " + newName);
        System.out.printf("%d: cloning vApp%n", System.currentTimeMillis());
        Task task = this.tmClient.cloneVAppInVDC(this.vdc.getHref(), this.vApp.getHref(), newName, new CloneVAppOptions[]{options});
        assert (this.successTester.apply((Object)task.getHref()));
        System.out.printf("%d: done cloning vApp%n", System.currentTimeMillis());
        assert (this.successTester.apply((Object)this.tmClient.powerOnVApp(this.vApp.getHref()).getHref()));
        System.out.printf("%d: done powering on vApp%n", System.currentTimeMillis());
        task = this.tmClient.getTask(task.getHref());
        this.clone = this.tmClient.getVApp(task.getOwner().getHref());
        Assert.assertEquals((Object)this.clone.getStatus(), (Object)Status.ON);
        Assert.assertEquals((String)this.clone.getName(), (String)newName);
        Assert.assertEquals((int)this.clone.getNetworkToAddresses().values().size(), (int)1);
    }

    @Test(enabled=true, dependsOnMethods={"testInstantiateAndPowerOn", "testAddInternetService"})
    public void testPublicIp() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        this.node = this.tmClient.addNode(this.is.getId(), (String)Iterables.getLast((Iterable)this.vApp.getNetworkToAddresses().values()), this.vApp.getName() + "-SSH", 22, new AddNodeOptions[0]);
        this.loopAndCheckPass();
    }

    private void loopAndCheckPass() throws IOException {
        for (int i = 0; i < 5; ++i) {
            try {
                this.doCheckPass(this.publicIp);
                return;
            }
            catch (SshException e) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    @Test(enabled=true, dependsOnMethods={"testPublicIp"})
    public void testConfigureNode() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        this.tmClient.configureNode(this.node.getId(), this.node.getName(), this.node.isEnabled(), "holy cow");
    }

    @Test(enabled=true, dependsOnMethods={"testPublicIp"})
    public void testLifeCycle() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        try {
            this.tmClient.undeployVApp(this.vApp.getHref());
        }
        catch (HttpResponseException e) {
            Assert.assertEquals((int)e.getResponse().getStatusCode(), (int)501);
        }
        try {
            this.tmClient.suspendVApp(this.vApp.getHref());
        }
        catch (HttpResponseException e) {
            Assert.assertEquals((int)e.getResponse().getStatusCode(), (int)501);
        }
        assert (this.successTester.apply((Object)this.tmClient.resetVApp(this.vApp.getHref()).getHref()));
        this.vApp = this.tmClient.getVApp(this.vApp.getHref());
        Assert.assertEquals((Object)this.vApp.getStatus(), (Object)Status.ON);
        assert (this.successTester.apply((Object)this.tmClient.powerOffVApp(this.vApp.getHref()).getHref()));
        this.vApp = this.tmClient.getVApp(this.vApp.getHref());
        Assert.assertEquals((Object)this.vApp.getStatus(), (Object)Status.OFF);
    }

    @Test(enabled=true, dependsOnMethods={"testLifeCycle"})
    public void testConfigure() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        this.vApp = this.tmClient.getVApp(this.vApp.getHref());
        Task task = this.tmClient.configureVApp(this.vApp, VAppConfiguration.Builder.changeNameTo((String)"eduardo").changeMemoryTo(1536L).changeProcessorCountTo(1).addDisk(0x1900000L).addDisk(0x1900000L));
        assert (this.successTester.apply((Object)task.getHref()));
        this.vApp = this.tmClient.getVApp(this.vApp.getHref());
        Assert.assertEquals((String)this.vApp.getName(), (String)"eduardo");
        Assert.assertEquals((long)((ResourceAllocation)Iterables.find((Iterable)this.vApp.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.PROCESSOR))).getVirtualQuantity(), (long)1L);
        Assert.assertEquals((long)((ResourceAllocation)Iterables.find((Iterable)this.vApp.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.MEMORY))).getVirtualQuantity(), (long)1536L);
        Assert.assertEquals((int)Iterables.size((Iterable)Iterables.filter((Iterable)this.vApp.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.DISK_DRIVE))), (int)3);
        assert (this.successTester.apply((Object)this.tmClient.powerOnVApp(this.vApp.getHref()).getHref()));
        this.loopAndCheckPass();
        assert (this.successTester.apply((Object)this.tmClient.powerOffVApp(this.vApp.getHref()).getHref()));
        ArrayList disks = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.vApp.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.DISK_DRIVE)));
        task = this.tmClient.configureVApp(this.vApp, VAppConfiguration.Builder.deleteDiskWithAddressOnParent((int)((ResourceAllocation)disks.get(1)).getAddressOnParent()));
        assert (this.successTester.apply((Object)task.getHref()));
        assert (this.successTester.apply((Object)this.tmClient.powerOnVApp(this.vApp.getHref()).getHref()));
        this.loopAndCheckPass();
    }

    private void verifyConfigurationOfVApp(VCloudExpressVApp vApp, String serverName, String expectedOs, int processorCount, long memory, long hardDisk) {
        Assert.assertEquals((String)vApp.getName(), (String)serverName);
        Assert.assertEquals((String)vApp.getOperatingSystemDescription(), (String)expectedOs);
        Assert.assertEquals((long)((ResourceAllocation)Iterables.find((Iterable)vApp.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.PROCESSOR))).getVirtualQuantity(), (long)processorCount);
        Assert.assertEquals((long)((ResourceAllocation)Iterables.find((Iterable)vApp.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.SCSI_CONTROLLER))).getVirtualQuantity(), (long)1L);
        Assert.assertEquals((long)((ResourceAllocation)Iterables.find((Iterable)vApp.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.MEMORY))).getVirtualQuantity(), (long)memory);
        Assert.assertEquals((long)((ResourceAllocation)Iterables.find((Iterable)vApp.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.DISK_DRIVE))).getVirtualQuantity(), (long)hardDisk);
        Assert.assertEquals((long)vApp.getSize(), (long)((ResourceAllocation)Iterables.find((Iterable)vApp.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.DISK_DRIVE))).getVirtualQuantity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckPass(String address) throws IOException {
        IPSocket socket = new IPSocket(address, 22);
        System.out.printf("%d: %s awaiting ssh service to start%n", System.currentTimeMillis(), socket);
        assert (this.socketTester.apply((Object)socket));
        System.out.printf("%d: %s ssh service started%n", System.currentTimeMillis(), socket);
        SshClient connection = this.getConnectionFor(socket);
        try {
            connection.connect();
            System.out.printf("%d: %s ssh connection made%n", System.currentTimeMillis(), socket);
            System.out.println(connection.exec("df -h"));
            System.out.println(connection.exec("ls -al /dev/sd*"));
            System.out.println(connection.exec("echo '$Ep455l0ud!2'|sudo -S fdisk -l"));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected abstract SshClient getConnectionFor(IPSocket var1);

    @AfterTest
    void cleanup() throws InterruptedException, ExecutionException, TimeoutException {
        if (this.node != null) {
            this.tmClient.deleteNode(this.node.getId());
        }
        if (this.is != null) {
            this.tmClient.deleteInternetService(this.is.getId());
        }
        if (this.vApp != null) {
            try {
                this.successTester.apply((Object)this.tmClient.powerOffVApp(this.vApp.getHref()).getHref());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.tmClient.deleteVApp(this.vApp.getHref());
        }
        if (this.clone != null) {
            try {
                this.successTester.apply((Object)this.tmClient.powerOffVApp(this.clone.getHref()).getHref());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tmClient.deleteVApp(this.clone.getHref());
        }
    }

    protected void setupCredentials() {
        this.identity = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".identity"), (Object)("test." + this.provider + ".identity"));
        this.credential = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".credential"), (Object)("test." + this.provider + ".credential"));
        this.endpoint = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".endpoint"), (Object)("test." + this.provider + ".endpoint"));
        this.apiversion = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".apiversion"), (Object)("test." + this.provider + ".apiversion"));
    }

    protected Properties setupProperties() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.trust-all-certs", "true");
        overrides.setProperty("jclouds.relax-hostname", "true");
        overrides.setProperty(this.provider + ".identity", this.identity);
        overrides.setProperty(this.provider + ".credential", this.credential);
        overrides.setProperty(this.provider + ".endpoint", this.endpoint);
        overrides.setProperty(this.provider + ".apiversion", this.apiversion);
        return overrides;
    }

    @BeforeGroups(groups={"live"})
    public void setupClient() {
        this.setupCredentials();
        Properties overrides = this.setupProperties();
        Injector injector = new RestContextFactory().createContextBuilder(this.provider, (Iterable)ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)new JschSshClientModule()), overrides).buildInjector();
        this.tmClient = (TerremarkVCloudClient)injector.getInstance(TerremarkVCloudClient.class);
        this.connection = this.tmClient;
        this.sshFactory = (SshClient.Factory)injector.getInstance(SshClient.Factory.class);
        this.socketTester = new RetryablePredicate((Predicate)injector.getInstance(SocketOpen.class), 130L, 10L, TimeUnit.SECONDS);
        this.successTester = new RetryablePredicate((Predicate)injector.getInstance(TaskSuccess.class), 650L, 10L, TimeUnit.SECONDS);
    }
}

