/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.binders;

import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.util.Utils;
import org.jclouds.vcloud.terremark.binders.BindAddNodeServiceToXmlPayload;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="vcloud.BindAddNodeServiceToXmlPayloadTest")
public class BindAddNodeServiceToXmlPayloadTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.terremark.extension.ns")).to("urn:tmrk:vCloudExpressExtensions-1.6");
        }

        @Singleton
        @Provides
        @Named(value="CreateNodeService")
        String provideInstantiateVAppTemplateParams() throws IOException {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/terremark/CreateNodeService.xml");
            return Utils.toStringAndClose((InputStream)is);
        }
    }});

    public void testApplyInputStream() throws IOException {
        String expected = Utils.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/terremark/CreateNodeService-test.xml"));
        HttpRequest request = new HttpRequest("GET", URI.create("http://test"));
        BindAddNodeServiceToXmlPayload binder = (BindAddNodeServiceToXmlPayload)this.injector.getInstance(BindAddNodeServiceToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("name", "Node for Jim");
        map.put("ipAddress", "172.16.20.3");
        map.put("port", "80");
        map.put("enabled", "false");
        map.put("description", "Some test node");
        binder.bindToRequest(request, (Map)map);
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)expected);
    }
}

