/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Singleton;
import org.easymock.classextension.EasyMock;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Utils;
import org.jclouds.vcloud.domain.network.NetworkConfig;
import org.jclouds.vcloud.endpoints.Network;
import org.jclouds.vcloud.terremark.TerremarkVCloudPropertiesBuilder;
import org.jclouds.vcloud.terremark.binders.TerremarkBindInstantiateVAppTemplateParamsToXmlPayload;
import org.jclouds.vcloud.terremark.options.TerremarkInstantiateVAppTemplateOptions;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="vcloud.TerremarkBindInstantiateVAppTemplateParamsToXmlPayloadTest")
public class TerremarkBindInstantiateVAppTemplateParamsToXmlPayloadTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            Properties props = new Properties();
            Names.bindProperties((Binder)this.binder(), (Properties)((Properties)Preconditions.checkNotNull((Object)new TerremarkVCloudPropertiesBuilder(props).build(), (Object)"properties")));
        }

        @Network
        @Provides
        @Singleton
        URI provideNetwork() {
            return URI.create("https://vcloud.safesecureweb.com/network/1990");
        }
    }});

    public void testAllOptions() throws IOException {
        String expected = Utils.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/terremark/InstantiateVAppTemplateParams-options-test.xml"));
        Multimap headers = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        org.easymock.EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("http://localhost/key")).anyTimes();
        org.easymock.EasyMock.expect((Object)request.getArgs()).andReturn((Object)new Object[]{TerremarkInstantiateVAppTemplateOptions.Builder.processorCount((int)2).memory(512L).inGroup("group").withPassword("password").inRow("row").addNetworkConfig(new NetworkConfig(URI.create("http://network")))}).atLeastOnce();
        org.easymock.EasyMock.expect((Object)request.getFirstHeaderOrNull("Content-Type")).andReturn((Object)"application/unknown").atLeastOnce();
        org.easymock.EasyMock.expect((Object)request.getHeaders()).andReturn((Object)headers).atLeastOnce();
        request.setPayload(expected);
        EasyMock.replay((Object[])new Object[]{request});
        TerremarkBindInstantiateVAppTemplateParamsToXmlPayload binder = (TerremarkBindInstantiateVAppTemplateParamsToXmlPayload)this.injector.getInstance(TerremarkBindInstantiateVAppTemplateParamsToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("name", "name");
        map.put("template", "https://vcloud/vAppTemplate/3");
        binder.bindToRequest((HttpRequest)request, (Map)map);
    }
}

