/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute;

import com.google.common.base.Predicate;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import javax.inject.Provider;
import org.easymock.classextension.EasyMock;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VCloudExpressVApp;
import org.jclouds.vcloud.domain.VCloudExpressVAppTemplate;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;
import org.jclouds.vcloud.terremark.TerremarkVCloudExpressClient;
import org.jclouds.vcloud.terremark.compute.TerremarkVCloudComputeClient;
import org.jclouds.vcloud.terremark.compute.strategy.ParseVAppTemplateDescriptionToGetDefaultLoginCredentials;
import org.jclouds.vcloud.terremark.domain.TerremarkVDC;
import org.jclouds.vcloud.terremark.options.TerremarkInstantiateVAppTemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="terremark.TerremarkVCloudComputeClientTest")
public class TerremarkVCloudComputeClientTest {
    @Test
    public void testStartWindows() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/terremark/windows_description.txt");
        String description = new String(ByteStreams.toByteArray((InputStream)is));
        VCloudExpressVAppTemplate template = (VCloudExpressVAppTemplate)EasyMock.createMock(VCloudExpressVAppTemplate.class);
        TerremarkVDC vdc = (TerremarkVDC)EasyMock.createMock(TerremarkVDC.class);
        URI templateURI = URI.create("template");
        URI vdcURI = URI.create("vdc");
        org.easymock.EasyMock.expect((Object)template.getDescription()).andReturn((Object)description).atLeastOnce();
        TerremarkVCloudExpressClient client = (TerremarkVCloudExpressClient)EasyMock.createMock(TerremarkVCloudExpressClient.class);
        VCloudExpressVApp vApp = (VCloudExpressVApp)EasyMock.createMock(VCloudExpressVApp.class);
        org.easymock.EasyMock.expect((Object)client.getVAppTemplate(templateURI)).andReturn((Object)template);
        org.easymock.EasyMock.expect((Object)client.getVAppTemplate(templateURI)).andReturn((Object)template);
        org.easymock.EasyMock.expect((Object)client.instantiateVAppTemplateInVDC(vdcURI, templateURI, "name", new InstantiateVAppTemplateOptions[]{new TerremarkInstantiateVAppTemplateOptions().productProperty("password", "password")})).andReturn((Object)vApp);
        Task task = (Task)EasyMock.createMock(Task.class);
        URI vappLocation = URI.create("vapp");
        URI taskLocation = URI.create("task");
        org.easymock.EasyMock.expect((Object)vApp.getHref()).andReturn((Object)vappLocation).atLeastOnce();
        org.easymock.EasyMock.expect((Object)vApp.getName()).andReturn((Object)"name").atLeastOnce();
        org.easymock.EasyMock.expect((Object)client.deployVApp(vappLocation)).andReturn((Object)task);
        org.easymock.EasyMock.expect((Object)task.getHref()).andReturn((Object)taskLocation).atLeastOnce();
        Predicate successTester = (Predicate)EasyMock.createMock(Predicate.class);
        org.easymock.EasyMock.expect((Object)successTester.apply((Object)taskLocation)).andReturn((Object)true).atLeastOnce();
        org.easymock.EasyMock.expect((Object)client.powerOnVApp(vappLocation)).andReturn((Object)task);
        Predicate notFoundTester = (Predicate)EasyMock.createMock(Predicate.class);
        Map vAppStatusToNodeState = (Map)EasyMock.createMock(Map.class);
        TerremarkVCloudComputeClient computeClient = new TerremarkVCloudComputeClient(client, (PopulateDefaultLoginCredentialsForImageStrategy)new ParseVAppTemplateDescriptionToGetDefaultLoginCredentials(), (Provider)new Provider<String>(){

            public String get() {
                return "password";
            }
        }, successTester, vAppStatusToNodeState);
        EasyMock.replay((Object[])new Object[]{vdc});
        EasyMock.replay((Object[])new Object[]{template});
        EasyMock.replay((Object[])new Object[]{vApp});
        EasyMock.replay((Object[])new Object[]{task});
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{successTester});
        EasyMock.replay((Object[])new Object[]{notFoundTester});
        EasyMock.replay((Object[])new Object[]{vAppStatusToNodeState});
        Map response = computeClient.start(vdcURI, templateURI, "name", (InstantiateVAppTemplateOptions)new TerremarkInstantiateVAppTemplateOptions(), new int[0]);
        Assert.assertEquals((String)((String)response.get("id")), (String)"vapp");
        Assert.assertEquals((String)((String)response.get("username")), (String)"Administrator");
        Assert.assertEquals((String)((String)response.get("password")), (String)"password");
        EasyMock.verify((Object[])new Object[]{vdc});
        EasyMock.verify((Object[])new Object[]{template});
        EasyMock.verify((Object[])new Object[]{vApp});
        EasyMock.verify((Object[])new Object[]{task});
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{successTester});
        EasyMock.verify((Object[])new Object[]{notFoundTester});
        EasyMock.verify((Object[])new Object[]{vAppStatusToNodeState});
    }
}

