/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute;

import org.jclouds.compute.BaseComputeServiceLiveTest;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.rest.RestContext;
import org.jclouds.ssh.jsch.config.JschSshClientModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, enabled=true, sequential=true, testName="terremark.TerremarkVCloudComputeServiceLiveTest")
public class TerremarkVCloudExpressComputeServiceLiveTest
extends BaseComputeServiceLiveTest {
    public TerremarkVCloudExpressComputeServiceLiveTest() {
        this.provider = "trmk-vcloudexpress";
    }

    public void setServiceDefaults() {
        this.tag = "vcx";
    }

    @Test
    public void testTemplateBuilder() {
        Template defaultTemplate = this.client.templateBuilder().build();
        Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((String)defaultTemplate.getLocation().getDescription(), (String)"Miami Environment 1");
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)1.0);
    }

    public void testAssignability() throws Exception {
        RestContext tmContext = new ComputeServiceContextFactory().createContext(this.provider, this.identity, this.credential).getProviderSpecificContext();
    }

    protected Template buildTemplate(TemplateBuilder templateBuilder) {
        Template template = super.buildTemplate(templateBuilder);
        Image image = template.getImage();
        assert (image.getDefaultCredentials().identity != null) : image;
        assert (image.getDefaultCredentials().credential != null) : image;
        return template;
    }

    protected void checkOsMatchesTemplate(NodeMetadata node) {
        if (node.getOperatingSystem() != null) {
            Assert.assertEquals((Object)node.getOperatingSystem().getFamily(), null);
        }
    }

    public void testListImages() throws Exception {
        for (Image image : this.client.listImages()) {
            assert (image.getProviderId() != null) : image;
            Assert.assertEquals((Object)image.getType(), (Object)ComputeType.IMAGE);
            assert (image.getDefaultCredentials().identity != null) : image;
            if (image.getOperatingSystem().getFamily() != OsFamily.WINDOWS) assert (image.getDefaultCredentials().credential != null) : image;
        }
    }

    public void testListNodes() throws Exception {
        for (ComputeMetadata node : this.client.listNodes()) {
            assert (node.getProviderId() != null);
            assert (node.getLocation() != null);
            Assert.assertEquals((Object)node.getType(), (Object)ComputeType.NODE);
            NodeMetadata allData = this.client.getNodeMetadata(node.getId());
            System.out.println(allData.getHardware());
        }
    }

    protected JschSshClientModule getSshModule() {
        return new JschSshClientModule();
    }
}

