/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.strategy;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import org.easymock.classextension.EasyMock;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.vcloud.terremark.compute.domain.OrgAndName;
import org.jclouds.vcloud.terremark.compute.functions.NodeMetadataToOrgAndName;
import org.jclouds.vcloud.terremark.compute.strategy.CleanupOrphanKeys;
import org.jclouds.vcloud.terremark.compute.strategy.DeleteKeyPair;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="terremark.CleanupOrphanKeysTest")
public class CleanupOrphanKeysTest {
    public void testWhenNoDeletedNodes() {
        ImmutableSet deadOnes = ImmutableSet.of();
        CleanupOrphanKeys strategy = this.setupStrategy();
        this.replayStrategy(strategy);
        strategy.execute((Iterable)deadOnes);
        this.verifyStrategy(strategy);
    }

    public void testWhenDeletedNodesHaveNoTag() {
        CleanupOrphanKeys strategy = this.setupStrategy();
        NodeMetadata nodeMetadata = (NodeMetadata)EasyMock.createMock(NodeMetadata.class);
        ImmutableSet deadOnes = ImmutableSet.of((Object)nodeMetadata);
        org.easymock.EasyMock.expect((Object)strategy.nodeToOrgAndName.apply((Object)nodeMetadata)).andReturn(null).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{nodeMetadata});
        this.replayStrategy(strategy);
        strategy.execute((Iterable)deadOnes);
        EasyMock.verify((Object[])new Object[]{nodeMetadata});
        this.verifyStrategy(strategy);
    }

    public void testWhenStillRunningWithTag() {
        CleanupOrphanKeys strategy = this.setupStrategy();
        NodeMetadata nodeMetadata = (NodeMetadata)EasyMock.createMock(NodeMetadata.class);
        ImmutableSet deadOnes = ImmutableSet.of((Object)nodeMetadata);
        OrgAndName orgTag = new OrgAndName(URI.create("location"), "tag");
        org.easymock.EasyMock.expect((Object)strategy.nodeToOrgAndName.apply((Object)nodeMetadata)).andReturn((Object)orgTag).atLeastOnce();
        org.easymock.EasyMock.expect((Object)strategy.listNodes.listDetailsOnNodesMatching(NodePredicates.parentLocationId((String)orgTag.getOrg().toASCIIString()))).andReturn((Object)ImmutableSet.of((Object)nodeMetadata));
        org.easymock.EasyMock.expect((Object)nodeMetadata.getTag()).andReturn((Object)orgTag.getName()).atLeastOnce();
        org.easymock.EasyMock.expect((Object)nodeMetadata.getState()).andReturn((Object)NodeState.RUNNING).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{nodeMetadata});
        this.replayStrategy(strategy);
        strategy.execute((Iterable)deadOnes);
        EasyMock.verify((Object[])new Object[]{nodeMetadata});
        this.verifyStrategy(strategy);
    }

    public void testWhenTerminatedWithTag() {
        CleanupOrphanKeys strategy = this.setupStrategy();
        NodeMetadata nodeMetadata = (NodeMetadata)EasyMock.createMock(NodeMetadata.class);
        ImmutableSet deadOnes = ImmutableSet.of((Object)nodeMetadata);
        OrgAndName orgTag = new OrgAndName(URI.create("location"), "tag");
        org.easymock.EasyMock.expect((Object)strategy.nodeToOrgAndName.apply((Object)nodeMetadata)).andReturn((Object)orgTag).atLeastOnce();
        org.easymock.EasyMock.expect((Object)strategy.listNodes.listDetailsOnNodesMatching(NodePredicates.parentLocationId((String)orgTag.getOrg().toASCIIString()))).andReturn((Object)ImmutableSet.of((Object)nodeMetadata));
        org.easymock.EasyMock.expect((Object)nodeMetadata.getTag()).andReturn((Object)orgTag.getName()).atLeastOnce();
        org.easymock.EasyMock.expect((Object)nodeMetadata.getState()).andReturn((Object)NodeState.TERMINATED).atLeastOnce();
        strategy.deleteKeyPair.execute(orgTag);
        EasyMock.replay((Object[])new Object[]{nodeMetadata});
        this.replayStrategy(strategy);
        strategy.execute((Iterable)deadOnes);
        EasyMock.verify((Object[])new Object[]{nodeMetadata});
        this.verifyStrategy(strategy);
    }

    public void testWhenNoneLeftWithTag() {
        CleanupOrphanKeys strategy = this.setupStrategy();
        NodeMetadata nodeMetadata = (NodeMetadata)EasyMock.createMock(NodeMetadata.class);
        ImmutableSet deadOnes = ImmutableSet.of((Object)nodeMetadata);
        OrgAndName orgTag = new OrgAndName(URI.create("location"), "tag");
        org.easymock.EasyMock.expect((Object)strategy.nodeToOrgAndName.apply((Object)nodeMetadata)).andReturn((Object)orgTag).atLeastOnce();
        org.easymock.EasyMock.expect((Object)strategy.listNodes.listDetailsOnNodesMatching(NodePredicates.parentLocationId((String)orgTag.getOrg().toASCIIString()))).andReturn((Object)ImmutableSet.of());
        strategy.deleteKeyPair.execute(orgTag);
        EasyMock.replay((Object[])new Object[]{nodeMetadata});
        this.replayStrategy(strategy);
        strategy.execute((Iterable)deadOnes);
        EasyMock.verify((Object[])new Object[]{nodeMetadata});
        this.verifyStrategy(strategy);
    }

    private void verifyStrategy(CleanupOrphanKeys strategy) {
        EasyMock.verify((Object[])new Object[]{strategy.nodeToOrgAndName});
        EasyMock.verify((Object[])new Object[]{strategy.deleteKeyPair});
        EasyMock.verify((Object[])new Object[]{strategy.listNodes});
    }

    private CleanupOrphanKeys setupStrategy() {
        NodeMetadataToOrgAndName nodeToOrgAndName = (NodeMetadataToOrgAndName)EasyMock.createMock(NodeMetadataToOrgAndName.class);
        DeleteKeyPair deleteKeyPair = (DeleteKeyPair)EasyMock.createMock(DeleteKeyPair.class);
        ListNodesStrategy listNodes = (ListNodesStrategy)EasyMock.createMock(ListNodesStrategy.class);
        return new CleanupOrphanKeys((Function)nodeToOrgAndName, deleteKeyPair, listNodes);
    }

    private void replayStrategy(CleanupOrphanKeys strategy) {
        EasyMock.replay((Object[])new Object[]{strategy.nodeToOrgAndName});
        EasyMock.replay((Object[])new Object[]{strategy.deleteKeyPair});
        EasyMock.replay((Object[])new Object[]{strategy.listNodes});
    }
}

