/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.strategy;

import java.net.URI;
import java.util.concurrent.ConcurrentMap;
import org.easymock.classextension.EasyMock;
import org.jclouds.vcloud.terremark.compute.domain.KeyPairCredentials;
import org.jclouds.vcloud.terremark.compute.domain.OrgAndName;
import org.jclouds.vcloud.terremark.compute.functions.CreateUniqueKeyPair;
import org.jclouds.vcloud.terremark.compute.options.TerremarkVCloudTemplateOptions;
import org.jclouds.vcloud.terremark.compute.strategy.CreateNewKeyPairUnlessUserSpecifiedOtherwise;
import org.jclouds.vcloud.terremark.domain.KeyPair;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="terremark.CreateNewKeyPairUnlessUserSpecifiedOtherwiseTest")
public class CreateNewKeyPairUnlessUserSpecifiedOtherwiseTest {
    public void testExecuteWithDefaultOptionsAlreadyHasKey() throws SecurityException, NoSuchMethodException {
        URI org = URI.create("org1");
        String identity = "identity";
        String tag = "tag";
        OrgAndName orgAndName = new OrgAndName(org, "tag");
        String systemGeneratedFingerprint = "systemGeneratedKeyPairfinger";
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        CreateNewKeyPairUnlessUserSpecifiedOtherwise strategy = this.setupStrategy();
        KeyPairCredentials keyPairCredentials = (KeyPairCredentials)EasyMock.createMock(KeyPairCredentials.class);
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        org.easymock.EasyMock.expect((Object)strategy.credentialsMap.containsKey(orgAndName)).andReturn((Object)true);
        org.easymock.EasyMock.expect(strategy.credentialsMap.get(orgAndName)).andReturn((Object)keyPairCredentials);
        org.easymock.EasyMock.expect((Object)keyPairCredentials.getKeyPair()).andReturn((Object)keyPair);
        org.easymock.EasyMock.expect((Object)keyPair.getFingerPrint()).andReturn((Object)systemGeneratedFingerprint).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{keyPair});
        EasyMock.replay((Object[])new Object[]{keyPairCredentials});
        this.replayStrategy(strategy);
        strategy.execute(org, tag, identity, options);
        Assert.assertEquals((String)options.getSshKeyFingerprint(), (String)"systemGeneratedKeyPairfinger");
        EasyMock.verify((Object[])new Object[]{keyPair});
        EasyMock.verify((Object[])new Object[]{keyPairCredentials});
        this.verifyStrategy(strategy);
    }

    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_reusesKeyWhenToldTo() {
        URI org = URI.create("org1");
        String identity = "identity";
        String tag = "tag";
        TerremarkVCloudTemplateOptions options = TerremarkVCloudTemplateOptions.Builder.sshKeyFingerprint((String)"fingerprintFromUser");
        CreateNewKeyPairUnlessUserSpecifiedOtherwise strategy = this.setupStrategy();
        this.replayStrategy(strategy);
        strategy.execute(org, tag, identity, options);
        Assert.assertEquals((String)options.getSshKeyFingerprint(), (String)"fingerprintFromUser");
        this.verifyStrategy(strategy);
    }

    @Test(enabled=false)
    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_createsNewKeyPairAndReturnsItsNameByDefault() {
        URI org = URI.create("org1");
        String identity = "identity";
        String tag = "tag";
        String systemGeneratedFingerprint = "systemGeneratedKeyPairfinger";
        String privateKey = "privateKey";
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        OrgAndName orgAndName = new OrgAndName(org, "tag");
        CreateNewKeyPairUnlessUserSpecifiedOtherwise strategy = this.setupStrategy();
        KeyPairCredentials keyPairCredentials = (KeyPairCredentials)EasyMock.createMock(KeyPairCredentials.class);
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        org.easymock.EasyMock.expect((Object)strategy.credentialsMap.containsKey(orgAndName)).andReturn((Object)false);
        org.easymock.EasyMock.expect((Object)strategy.createUniqueKeyPair.apply(orgAndName)).andReturn((Object)keyPair);
        org.easymock.EasyMock.expect((Object)keyPair.getFingerPrint()).andReturn((Object)systemGeneratedFingerprint).atLeastOnce();
        org.easymock.EasyMock.expect((Object)keyPair.getPrivateKey()).andReturn((Object)privateKey).atLeastOnce();
        org.easymock.EasyMock.expect((Object)strategy.credentialsMap.put(orgAndName, keyPairCredentials)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        strategy.execute(org, tag, identity, options);
        Assert.assertEquals((String)options.getSshKeyFingerprint(), (String)systemGeneratedFingerprint);
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_doesntCreateAKeyPairAndReturnsNullWhenToldNotTo() {
        URI org = URI.create("org1");
        String identity = "identity";
        String tag = "tag";
        TerremarkVCloudTemplateOptions options = TerremarkVCloudTemplateOptions.Builder.noKeyPair();
        CreateNewKeyPairUnlessUserSpecifiedOtherwise strategy = this.setupStrategy();
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        strategy.execute(org, tag, identity, options);
        Assert.assertEquals((String)options.getSshKeyFingerprint(), null);
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    private void verifyStrategy(CreateNewKeyPairUnlessUserSpecifiedOtherwise strategy) {
        EasyMock.verify((Object[])new Object[]{strategy.credentialsMap});
        EasyMock.verify((Object[])new Object[]{strategy.createUniqueKeyPair});
    }

    private CreateNewKeyPairUnlessUserSpecifiedOtherwise setupStrategy() {
        ConcurrentMap credentialsMap = (ConcurrentMap)EasyMock.createMock(ConcurrentMap.class);
        CreateUniqueKeyPair createUniqueKeyPair = (CreateUniqueKeyPair)EasyMock.createMock(CreateUniqueKeyPair.class);
        return new CreateNewKeyPairUnlessUserSpecifiedOtherwise(credentialsMap, createUniqueKeyPair);
    }

    private void replayStrategy(CreateNewKeyPairUnlessUserSpecifiedOtherwise strategy) {
        EasyMock.replay((Object[])new Object[]{strategy.credentialsMap});
        EasyMock.replay((Object[])new Object[]{strategy.createUniqueKeyPair});
    }
}

