/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.strategy;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.concurrent.ConcurrentMap;
import org.easymock.classextension.EasyMock;
import org.jclouds.vcloud.terremark.TerremarkVCloudExpressClient;
import org.jclouds.vcloud.terremark.compute.domain.OrgAndName;
import org.jclouds.vcloud.terremark.compute.strategy.DeleteKeyPair;
import org.jclouds.vcloud.terremark.domain.KeyPair;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="terremark.DeleteKeyPairTest")
public class DeleteKeyPairTest {
    public void testWhenNoKeyPairsInOrg() {
        URI org = URI.create("org1");
        OrgAndName orgTag = new OrgAndName(org, "tag");
        DeleteKeyPair strategy = this.setupStrategy();
        org.easymock.EasyMock.expect((Object)strategy.terremarkClient.listKeyPairsInOrg(orgTag.getOrg())).andReturn((Object)ImmutableSet.of());
        this.replayStrategy(strategy);
        strategy.execute(orgTag);
        this.verifyStrategy(strategy);
    }

    public void testWhenKeyPairMatches() {
        URI org = URI.create("org1");
        OrgAndName orgTag = new OrgAndName(org, "tag");
        DeleteKeyPair strategy = this.setupStrategy();
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        org.easymock.EasyMock.expect((Object)strategy.terremarkClient.listKeyPairsInOrg(orgTag.getOrg())).andReturn((Object)ImmutableSet.of((Object)keyPair));
        org.easymock.EasyMock.expect((Object)keyPair.getName()).andReturn((Object)("jclouds#" + orgTag.getName() + "#123")).atLeastOnce();
        org.easymock.EasyMock.expect((Object)keyPair.getId()).andReturn((Object)URI.create("1245"));
        strategy.terremarkClient.deleteKeyPair(URI.create("1245"));
        org.easymock.EasyMock.expect(strategy.credentialsMap.remove(orgTag)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        strategy.execute(orgTag);
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    public void testWhenKeyPairDoesntMatch() {
        URI org = URI.create("org1");
        OrgAndName orgTag = new OrgAndName(org, "tag");
        DeleteKeyPair strategy = this.setupStrategy();
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        org.easymock.EasyMock.expect((Object)strategy.terremarkClient.listKeyPairsInOrg(orgTag.getOrg())).andReturn((Object)ImmutableSet.of((Object)keyPair));
        org.easymock.EasyMock.expect((Object)keyPair.getName()).andReturn((Object)("kclouds#" + orgTag.getName() + "-123"));
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        strategy.execute(orgTag);
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    private void verifyStrategy(DeleteKeyPair strategy) {
        EasyMock.verify((Object[])new Object[]{strategy.credentialsMap});
        EasyMock.verify((Object[])new Object[]{strategy.terremarkClient});
    }

    private DeleteKeyPair setupStrategy() {
        ConcurrentMap credentialsMap = (ConcurrentMap)EasyMock.createMock(ConcurrentMap.class);
        TerremarkVCloudExpressClient terremarkClient = (TerremarkVCloudExpressClient)EasyMock.createMock(TerremarkVCloudExpressClient.class);
        return new DeleteKeyPair(terremarkClient, credentialsMap);
    }

    private void replayStrategy(DeleteKeyPair strategy) {
        EasyMock.replay((Object[])new Object[]{strategy.credentialsMap});
        EasyMock.replay((Object[])new Object[]{strategy.terremarkClient});
    }
}

