/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.strategy;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import org.easymock.classextension.EasyMock;
import org.jclouds.domain.Credentials;
import org.jclouds.vcloud.domain.VCloudExpressVAppTemplate;
import org.jclouds.vcloud.terremark.compute.strategy.ParseVAppTemplateDescriptionToGetDefaultLoginCredentials;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="terremark.PopulateDefaultLoginCredentialsForVAppTemplateTest")
public class PopulateDefaultLoginCredentialsForVAppTemplateTest {
    @Test
    public void testRhel() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/terremark/rhel_description.txt");
        String description = new String(ByteStreams.toByteArray((InputStream)is));
        VCloudExpressVAppTemplate template = (VCloudExpressVAppTemplate)EasyMock.createMock(VCloudExpressVAppTemplate.class);
        org.easymock.EasyMock.expect((Object)template.getDescription()).andReturn((Object)description).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{template});
        ParseVAppTemplateDescriptionToGetDefaultLoginCredentials converter = new ParseVAppTemplateDescriptionToGetDefaultLoginCredentials();
        Credentials creds = converter.execute((Object)template);
        Assert.assertEquals((String)creds.identity, (String)"vcloud");
        Assert.assertEquals((String)creds.credential, (String)"$Ep455l0ud!2");
        EasyMock.verify((Object[])new Object[]{template});
    }

    @Test
    public void testLamp() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/terremark/lamp_description.txt");
        String description = new String(ByteStreams.toByteArray((InputStream)is));
        VCloudExpressVAppTemplate template = (VCloudExpressVAppTemplate)EasyMock.createMock(VCloudExpressVAppTemplate.class);
        org.easymock.EasyMock.expect((Object)template.getDescription()).andReturn((Object)description).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{template});
        ParseVAppTemplateDescriptionToGetDefaultLoginCredentials converter = new ParseVAppTemplateDescriptionToGetDefaultLoginCredentials();
        Credentials creds = converter.execute((Object)template);
        Assert.assertEquals((String)creds.identity, (String)"ecloud");
        Assert.assertEquals((String)creds.credential, (String)"$Ep455l0ud!2");
        EasyMock.verify((Object[])new Object[]{template});
    }

    @Test
    public void testFt() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/terremark/ft_description.txt");
        String description = new String(ByteStreams.toByteArray((InputStream)is));
        VCloudExpressVAppTemplate template = (VCloudExpressVAppTemplate)EasyMock.createMock(VCloudExpressVAppTemplate.class);
        org.easymock.EasyMock.expect((Object)template.getDescription()).andReturn((Object)description).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{template});
        ParseVAppTemplateDescriptionToGetDefaultLoginCredentials converter = new ParseVAppTemplateDescriptionToGetDefaultLoginCredentials();
        Credentials creds = converter.execute((Object)template);
        Assert.assertEquals((String)creds.identity, (String)"vpncubed");
        Assert.assertEquals((String)creds.credential, (String)"vpncubed");
        EasyMock.verify((Object[])new Object[]{template});
    }

    @Test
    public void testWindows() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/terremark/windows_description.txt");
        String description = new String(ByteStreams.toByteArray((InputStream)is));
        VCloudExpressVAppTemplate template = (VCloudExpressVAppTemplate)EasyMock.createMock(VCloudExpressVAppTemplate.class);
        org.easymock.EasyMock.expect((Object)template.getDescription()).andReturn((Object)description).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{template});
        ParseVAppTemplateDescriptionToGetDefaultLoginCredentials converter = new ParseVAppTemplateDescriptionToGetDefaultLoginCredentials();
        Credentials creds = converter.execute((Object)template);
        Assert.assertEquals((String)creds.identity, (String)"Administrator");
        Assert.assertEquals((String)creds.credential, null);
        EasyMock.verify((Object[])new Object[]{template});
    }
}

