/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.suppliers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.jclouds.lifecycle.Closer;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.rest.RestContextFactory;
import org.jclouds.ssh.jsch.config.JschSshClientModule;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.functions.AllCatalogItemsInOrg;
import org.jclouds.vcloud.terremark.TerremarkVCloudClient;
import org.jclouds.vcloud.terremark.compute.suppliers.VAppTemplatesInOrgs;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, sequential=true, testName="terremark.VAppTemplatesInOrgsLiveTest")
public class VAppTemplatesInOrgsLiveTest {
    private TerremarkVCloudClient tmClient;
    private VAppTemplatesInOrgs parser;
    private Closer closer;
    private AllCatalogItemsInOrg allCatalogItemsInOrg;
    protected String provider = "trmk-vcloudexpress";
    protected String identity;
    protected String credential;
    protected String endpoint;
    protected String apiversion;

    protected void setupCredentials() {
        this.identity = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".identity"), (Object)("test." + this.provider + ".identity"));
        this.credential = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".credential"), (Object)("test." + this.provider + ".credential"));
        this.endpoint = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".endpoint"), (Object)("test." + this.provider + ".endpoint"));
        this.apiversion = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".apiversion"), (Object)("test." + this.provider + ".apiversion"));
    }

    protected Properties setupProperties() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.trust-all-certs", "true");
        overrides.setProperty("jclouds.relax-hostname", "true");
        overrides.setProperty(this.provider + ".identity", this.identity);
        overrides.setProperty(this.provider + ".credential", this.credential);
        overrides.setProperty(this.provider + ".endpoint", this.endpoint);
        overrides.setProperty(this.provider + ".apiversion", this.apiversion);
        return overrides;
    }

    @BeforeGroups(groups={"live"})
    public void setupClient() {
        this.setupCredentials();
        Properties overrides = this.setupProperties();
        Injector injector = new RestContextFactory().createContextBuilder(this.provider, (Iterable)ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)new JschSshClientModule()), overrides).buildInjector();
        this.tmClient = (TerremarkVCloudClient)injector.getInstance(TerremarkVCloudClient.class);
        this.allCatalogItemsInOrg = (AllCatalogItemsInOrg)injector.getInstance(AllCatalogItemsInOrg.class);
        this.parser = (VAppTemplatesInOrgs)injector.getInstance(VAppTemplatesInOrgs.class);
        this.closer = (Closer)injector.getInstance(Closer.class);
    }

    @Test
    public void testParseAllImages() {
        Set images = this.parser.get();
        Iterable templates = this.allCatalogItemsInOrg.apply((Org)this.tmClient.findOrgNamed(null));
        Assert.assertEquals((int)images.size(), (int)Iterables.size((Iterable)templates));
        assert (images.size() > 0);
    }

    @AfterGroups(groups={"live"})
    public void close() throws IOException {
        this.closer.close();
    }
}

