/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.handlers;

import java.net.URI;
import org.jclouds.http.BaseHttpErrorHandlerTest;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.vcloud.terremark.handlers.ParseTerremarkVCloudErrorFromHttpResponse;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseTerremarkVCloudErrorFromHttpResponseTest
extends BaseHttpErrorHandlerTest {
    @Test
    public void testGet400SetsIllegalArgumentException() {
        this.assertCodeMakes("GET", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/vdc/32"), 400, "HTTP/1.1 400 Service name is required.", "", IllegalArgumentException.class);
    }

    @Test
    public void testGet403SetsResourceNotFoundException() {
        this.assertCodeMakes("GET", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/vdc/32"), 403, "HTTP/1.1 403 Internet Service does not exist in the system. Internet Service was probably deleted by another user. Please refresh and retry the operation", "", ResourceNotFoundException.class);
    }

    @Test
    public void testDelete403SetsResourceNotFoundException() {
        this.assertCodeMakes("DELETE", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/vapp/361849"), 403, "HTTP/1.1 403 Server does not exist in the system. Server was probably deleted by another user. Please refresh and retry the operation", "", ResourceNotFoundException.class);
    }

    @Test
    public void testGet404SetsResourceNotFoundException() {
        this.assertCodeMakes("GET", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/vdc/32"), 404, "", "", ResourceNotFoundException.class);
    }

    @Test
    public void test401SetsAuthorizationException() {
        this.assertCodeMakes("GET", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/vdc/32"), 401, "", "", AuthorizationException.class);
    }

    protected Class<? extends HttpErrorHandler> getHandlerClass() {
        return ParseTerremarkVCloudErrorFromHttpResponse.class;
    }
}

