/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.options;

import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.NetworkConfig;
import org.jclouds.vcloud.terremark.options.TerremarkInstantiateVAppTemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="vcloud.TerremarkInstantiateVAppTemplateOptionsTest")
public class TerremarkInstantiateVAppTemplateOptionsTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});

    @Test
    public void testInGroup() {
        TerremarkInstantiateVAppTemplateOptions options = new TerremarkInstantiateVAppTemplateOptions();
        options.inGroup("group1");
        Assert.assertEquals((String)((String)options.getProperties().get("group")), (String)"group1");
    }

    @Test
    public void testInGroupStatic() {
        TerremarkInstantiateVAppTemplateOptions options = TerremarkInstantiateVAppTemplateOptions.Builder.inGroup((String)"group1");
        Assert.assertEquals((String)((String)options.getProperties().get("group")), (String)"group1");
    }

    @Test
    public void testInRow() {
        TerremarkInstantiateVAppTemplateOptions options = new TerremarkInstantiateVAppTemplateOptions();
        options.inRow("row1");
        Assert.assertEquals((String)((String)options.getProperties().get("row")), (String)"row1");
    }

    @Test
    public void testInRowStatic() {
        TerremarkInstantiateVAppTemplateOptions options = TerremarkInstantiateVAppTemplateOptions.Builder.inRow((String)"row1");
        Assert.assertEquals((String)((String)options.getProperties().get("row")), (String)"row1");
    }

    @Test
    public void testWithPassword() {
        TerremarkInstantiateVAppTemplateOptions options = new TerremarkInstantiateVAppTemplateOptions();
        options.withPassword("password1");
        Assert.assertEquals((String)((String)options.getProperties().get("password")), (String)"password1");
    }

    @Test
    public void testWithPasswordStatic() {
        TerremarkInstantiateVAppTemplateOptions options = TerremarkInstantiateVAppTemplateOptions.Builder.withPassword((String)"password1");
        Assert.assertEquals((String)((String)options.getProperties().get("password")), (String)"password1");
    }

    @Test
    public void testAddNetworkConfig() {
        TerremarkInstantiateVAppTemplateOptions options = new TerremarkInstantiateVAppTemplateOptions();
        options.addNetworkConfig(new NetworkConfig("default", URI.create("http://localhost"), FenceMode.BRIDGED));
        Assert.assertEquals((String)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getNetworkName(), (String)"default");
        Assert.assertEquals((Object)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getParentNetwork(), (Object)URI.create("http://localhost"));
        Assert.assertEquals((Object)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getFenceMode(), (Object)FenceMode.BRIDGED);
    }

    @Test
    public void testAddNetworkConfigStatic() {
        TerremarkInstantiateVAppTemplateOptions options = TerremarkInstantiateVAppTemplateOptions.Builder.addNetworkConfig((NetworkConfig)new NetworkConfig("default", URI.create("http://localhost"), FenceMode.BRIDGED));
        Assert.assertEquals((String)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getNetworkName(), (String)"default");
        Assert.assertEquals((Object)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getParentNetwork(), (Object)URI.create("http://localhost"));
        Assert.assertEquals((Object)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getFenceMode(), (Object)FenceMode.BRIDGED);
    }

    @Test
    public void testCpuCount() {
        Assert.assertEquals((String)TerremarkInstantiateVAppTemplateOptions.Builder.processorCount((int)3).getCpuCount(), (String)"3");
    }

    @Test
    public void testCpuCountStatic() {
        TerremarkInstantiateVAppTemplateOptions options = TerremarkInstantiateVAppTemplateOptions.Builder.processorCount((int)3);
        Assert.assertEquals((String)options.getCpuCount(), (String)"3");
    }

    @Test
    public void testMegabytes() {
        TerremarkInstantiateVAppTemplateOptions options = new TerremarkInstantiateVAppTemplateOptions();
        options.memory(512L);
        Assert.assertEquals((String)options.getMemorySizeMegabytes(), (String)"512");
    }

    @Test
    public void testMegabytesStatic() {
        TerremarkInstantiateVAppTemplateOptions options = TerremarkInstantiateVAppTemplateOptions.Builder.memory((long)512L);
        Assert.assertEquals((String)options.getMemorySizeMegabytes(), (String)"512");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDiskSizeKilobytes() {
        TerremarkInstantiateVAppTemplateOptions options = new TerremarkInstantiateVAppTemplateOptions();
        options.disk(512L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDiskSizeKilobytesStatic() {
        TerremarkInstantiateVAppTemplateOptions.Builder.disk((long)512L);
    }
}

