/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.xml;

import java.io.InputStream;
import java.net.URI;
import java.net.UnknownHostException;
import org.easymock.classextension.EasyMock;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.vcloud.terremark.domain.KeyPair;
import org.jclouds.vcloud.terremark.xml.KeyPairByNameHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="vcloud.KeyPairByNameHandlerTest")
public class KeyPairByNameHandlerTest
extends BaseHandlerTest {
    public void testGood() throws UnknownHostException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/terremark/keysList.xml");
        KeyPair result = (KeyPair)this.factory.create((ParseSax.HandlerWithResult)KeyPairByNameHandlerTest.addOrgAndNameToHandler((KeyPairByNameHandler)this.injector.getInstance(KeyPairByNameHandler.class), "org", "default")).parse(is);
        Assert.assertEquals((Object)result, (Object)new KeyPair(URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/extensions/key/9"), "default", true, null, "4e:af:8a:9f:e9:d2:72:d7:4b:a0:da:98:72:98:4d:7d"));
    }

    public void testNotFound() throws UnknownHostException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/terremark/keysList.xml");
        KeyPair result = (KeyPair)this.factory.create((ParseSax.HandlerWithResult)KeyPairByNameHandlerTest.addOrgAndNameToHandler((KeyPairByNameHandler)this.injector.getInstance(KeyPairByNameHandler.class), "org", "monster")).parse(is);
        Assert.assertEquals((Object)result, null);
    }

    private static KeyPairByNameHandler addOrgAndNameToHandler(KeyPairByNameHandler handler, String org, String name) {
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        org.easymock.EasyMock.expect((Object)request.getArgs()).andReturn((Object)new Object[]{org, name}).anyTimes();
        EasyMock.replay((Object[])new Object[]{request});
        handler.setContext((HttpRequest)request);
        return handler;
    }
}

