/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.xml;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.terremark.TerremarkVCloudPropertiesBuilder;
import org.jclouds.vcloud.terremark.domain.TerremarkCatalogItem;
import org.jclouds.vcloud.terremark.domain.internal.TerremarkCatalogItemImpl;
import org.jclouds.vcloud.terremark.xml.TerremarkCatalogItemHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="vcloud.TerremarkCatalogItemHandlerTest")
public class TerremarkCatalogItemHandlerTest
extends BaseHandlerTest {
    @BeforeTest
    protected void setUpInjector() {
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(){

            public void configure() {
                super.configure();
                Properties props = new Properties();
                Names.bindProperties((Binder)this.binder(), (Properties)((Properties)Preconditions.checkNotNull((Object)new TerremarkVCloudPropertiesBuilder(props).build(), (Object)"properties")));
            }
        }});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        assert (this.factory != null);
    }

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/terremark/catalogItem.xml");
        TerremarkCatalogItem result = (TerremarkCatalogItem)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(TerremarkCatalogItemHandler.class)).parse(is);
        Assert.assertEquals((Object)result, (Object)new TerremarkCatalogItemImpl("CentOS 5.3 (32-bit)", URI.create("https://services.vCloudexpress.terremark.com/api/v0.8a-13ext1.6/catalogItem/37-159"), null, (ReferenceType)new ReferenceTypeImpl("Compute Options", "application/vnd.tmrk.vcloudExpress.vappComputeOptionParameters+xml", URI.create("https://services.vCloudexpress.terremark.com/api/v0.8a-ext1.6/extensions/template/37-159/options/compute")), (ReferenceType)new ReferenceTypeImpl("Customization Options", "application/vnd.tmrk.vcloudExpress.vappCustomizationParameters+xml", URI.create("https://services.vCloudexpress.terremark.com/api/v0.8a-ext1.6/extensions/template/37-159/options/customization")), (ReferenceType)new ReferenceTypeImpl("CentOS 5.3 (32-bit)", "application/vnd.vmware.vCloud.vAppTemplate+xml", URI.create("https://services.vCloudexpress.terremark.com/api/v0.8a-ext1.6/vappTemplate/37")), (Map)ImmutableMap.of((Object)"LicensingCost", (Object)"0")));
    }
}

