/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.xml;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.VCloudExpressVApp;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.ovf.ResourceAllocation;
import org.jclouds.vcloud.domain.ovf.ResourceType;
import org.jclouds.vcloud.domain.ovf.System;
import org.jclouds.vcloud.predicates.VCloudPredicates;
import org.jclouds.vcloud.xml.VCloudExpressVAppHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="vcloud.VAppHandlerTest")
public class VAppHandlerTest
extends BaseHandlerTest {
    @BeforeTest
    protected void setUpInjector() {
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(), new AbstractModule(){

            protected void configure() {
                Properties toBind = new Properties();
                toBind.setProperty("jclouds.api-version", "0.8");
                Names.bindProperties((Binder)this.binder(), (Properties)toBind);
            }
        }});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
    }

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/terremark/launched_vapp.xml");
        VCloudExpressVApp result = (VCloudExpressVApp)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VCloudExpressVAppHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"adriantest");
        Assert.assertEquals((Object)result.getStatus(), (Object)Status.UNRESOLVED);
        Assert.assertEquals((long)result.getSize(), (long)4L);
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vapp/13775"));
        Assert.assertEquals((Object)result.getVDC(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vdc/32")));
    }

    public void testGetVApp() throws UnknownHostException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/terremark/get_vapp.xml");
        VCloudExpressVApp result = (VCloudExpressVApp)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VCloudExpressVAppHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"centos-53");
        Assert.assertEquals((Object)result.getStatus(), (Object)Status.OFF);
        Assert.assertEquals((long)result.getSize(), (long)0xA00000L);
        Assert.assertEquals((String)result.getOperatingSystemDescription(), (String)"Red Hat Enterprise Linux 5 (64-bit)");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vapp/16238"));
        Assert.assertEquals((Object)result.getVDC(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vdc/32")));
        Assert.assertEquals((Object)result.getSystem(), (Object)new System(0, "Virtual Hardware Family", "centos-53", (Iterable)ImmutableSet.of((Object)"vmx-07")));
        Assert.assertEquals((Collection)result.getNetworkToAddresses().get((Object)"Internal"), (Collection)ImmutableList.of((Object)"10.114.34.132"));
        ResourceAllocation cpu = new ResourceAllocation(1, "1 virtual CPU(s)", "Number of Virtual CPUs", ResourceType.PROCESSOR, null, null, null, null, null, null, 1L, "hertz * 10^6");
        ResourceAllocation controller = new ResourceAllocation(3, "SCSI Controller 0", "SCSI Controller", ResourceType.SCSI_CONTROLLER, "lsilogic", null, "0", null, null, null, 1L, null);
        ResourceAllocation memory = new ResourceAllocation(2, "512MB of memory", "Memory Size", ResourceType.MEMORY, null, null, null, null, null, null, 512L, "byte * 2^20");
        ResourceAllocation disk = new ResourceAllocation(9, "Hard Disk 1", null, ResourceType.DISK_DRIVE, null, "10485760", null, Integer.valueOf(0), Integer.valueOf(3), null, 0xA00000L, "byte * 2^20");
        Assert.assertEquals((Collection)result.getResourceAllocations(), (Collection)ImmutableSet.of((Object)cpu, (Object)memory, (Object)controller, (Object)disk));
        Assert.assertEquals((long)((ResourceAllocation)Iterables.find((Iterable)result.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.PROCESSOR))).getVirtualQuantity(), (long)1L);
        Assert.assertEquals((long)((ResourceAllocation)Iterables.find((Iterable)result.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.SCSI_CONTROLLER))).getVirtualQuantity(), (long)1L);
        Assert.assertEquals((long)((ResourceAllocation)Iterables.find((Iterable)result.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.MEMORY))).getVirtualQuantity(), (long)512L);
        Assert.assertEquals((long)((ResourceAllocation)Iterables.find((Iterable)result.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.DISK_DRIVE))).getVirtualQuantity(), (long)0xA00000L);
        Assert.assertEquals((long)result.getSize(), (long)((ResourceAllocation)Iterables.find((Iterable)result.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.DISK_DRIVE))).getVirtualQuantity());
    }

    public void testGetVApp2disks() throws UnknownHostException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/terremark/get_vapp2disks.xml");
        VCloudExpressVApp vApp = (VCloudExpressVApp)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VCloudExpressVAppHandler.class)).parse(is);
        Assert.assertEquals((String)vApp.getName(), (String)"eduardo");
        Assert.assertEquals((Object)vApp.getStatus(), (Object)Status.OFF);
        Assert.assertEquals((long)vApp.getSize(), (long)0x1D00000L);
        Assert.assertEquals((String)vApp.getOperatingSystemDescription(), (String)"Ubuntu Linux (32-bit)");
        Assert.assertEquals((Object)vApp.getHref(), (Object)URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vapp/15639"));
        Assert.assertEquals((Object)vApp.getVDC(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vdc/32")));
        Assert.assertEquals((Object)vApp.getSystem(), (Object)new System(0, "Virtual Hardware Family", "eduardo", (Iterable)ImmutableSet.of((Object)"vmx-07")));
        Assert.assertEquals((Collection)vApp.getNetworkToAddresses().get((Object)"Internal"), (Collection)ImmutableList.of((Object)"10.114.34.131"));
        ResourceAllocation cpu = new ResourceAllocation(1, "2 virtual CPU(s)", "Number of Virtual CPUs", ResourceType.PROCESSOR, null, null, null, null, null, null, 2L, "hertz * 10^6");
        ResourceAllocation controller = new ResourceAllocation(3, "SCSI Controller 0", "SCSI Controller", ResourceType.SCSI_CONTROLLER, "lsilogic", null, "0", null, null, null, 1L, null);
        ResourceAllocation memory = new ResourceAllocation(2, "1024MB of memory", "Memory Size", ResourceType.MEMORY, null, null, null, null, null, null, 1024L, "byte * 2^20");
        ResourceAllocation disk = new ResourceAllocation(9, "Hard Disk 1", null, ResourceType.DISK_DRIVE, null, "4194304", null, Integer.valueOf(0), Integer.valueOf(3), null, 0x400000L, "byte * 2^20");
        ResourceAllocation disk2 = new ResourceAllocation(9, "Hard Disk 2", null, ResourceType.DISK_DRIVE, null, "26214400", null, Integer.valueOf(1), Integer.valueOf(3), null, 0x1900000L, "byte * 2^20");
        Assert.assertEquals((Collection)vApp.getResourceAllocations(), (Collection)ImmutableSet.of((Object)cpu, (Object)memory, (Object)controller, (Object)disk, (Object)disk2));
        Assert.assertEquals((long)((ResourceAllocation)Iterables.find((Iterable)vApp.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.PROCESSOR))).getVirtualQuantity(), (long)2L);
        Assert.assertEquals((long)((ResourceAllocation)Iterables.find((Iterable)vApp.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.SCSI_CONTROLLER))).getVirtualQuantity(), (long)1L);
        Assert.assertEquals((long)((ResourceAllocation)Iterables.find((Iterable)vApp.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.MEMORY))).getVirtualQuantity(), (long)1024L);
        ArrayList disks = Lists.newArrayList((Iterable)Iterables.filter((Iterable)vApp.getResourceAllocations(), (Predicate)VCloudPredicates.resourceType((ResourceType)ResourceType.DISK_DRIVE)));
        Assert.assertEquals((long)((ResourceAllocation)disks.get(0)).getVirtualQuantity(), (long)0x400000L);
        Assert.assertEquals((long)((ResourceAllocation)disks.get(1)).getVirtualQuantity(), (long)0x1900000L);
    }
}

