/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.MapPayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;
import org.jclouds.vcloud.filters.SetVCloudTokenCookie;
import org.jclouds.vcloud.terremark.TerremarkVCloudAsyncClient;
import org.jclouds.vcloud.terremark.domain.InternetService;
import org.jclouds.vcloud.terremark.domain.Protocol;
import org.jclouds.vcloud.terremark.domain.PublicIpAddress;
import org.jclouds.vcloud.terremark.functions.VDCURIToInternetServicesEndpoint;
import org.jclouds.vcloud.terremark.functions.VDCURIToPublicIPsEndpoint;
import org.jclouds.vcloud.terremark.options.AddInternetServiceOptions;
import org.jclouds.vcloud.terremark.xml.InternetServiceHandler;
import org.jclouds.vcloud.terremark.xml.InternetServicesHandler;
import org.jclouds.vcloud.terremark.xml.PublicIpAddressesHandler;

@RequestFilters(value={SetVCloudTokenCookie.class})
public interface TerremarkECloudAsyncClient
extends TerremarkVCloudAsyncClient {
    @Override
    @GET
    @Path(value="")
    @Consumes(value={"application/vnd.tmrk.ecloud.internetServicesList+xml"})
    @XMLResponseParser(value=InternetServicesHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<InternetService>> getAllInternetServicesInVDC(@EndpointParam(parser=VDCURIToInternetServicesEndpoint.class) URI var1);

    @POST
    @Path(value="")
    @Consumes(value={"application/vnd.tmrk.ecloud.publicIp+xml"})
    @XMLResponseParser(value=PublicIpAddressesHandler.class)
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<PublicIpAddress> activatePublicIpInVDC(@EndpointParam(parser=VDCURIToPublicIPsEndpoint.class) URI var1);

    @Override
    @POST
    @Path(value="/internetServices")
    @Produces(value={"application/vnd.tmrk.ecloud.internetService+xml"})
    @Consumes(value={"application/vnd.tmrk.ecloud.internetService+xml"})
    @XMLResponseParser(value=InternetServiceHandler.class)
    @MapBinder(value=AddInternetServiceOptions.class)
    public ListenableFuture<? extends InternetService> addInternetServiceToExistingIp(@EndpointParam URI var1, @MapPayloadParam(value="name") String var2, @MapPayloadParam(value="protocol") Protocol var3, @MapPayloadParam(value="port") int var4, AddInternetServiceOptions ... var5);

    @Override
    @GET
    @Path(value="/internetServices")
    @Consumes(value={"application/vnd.tmrk.ecloud.internetServicesList+xml"})
    @XMLResponseParser(value=InternetServicesHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<InternetService>> getInternetServicesOnPublicIp(@EndpointParam URI var1);

    @Override
    @GET
    @Path(value="")
    @Consumes(value={"application/vnd.tmrk.ecloud.internetServicesList+xml"})
    @XMLResponseParser(value=InternetServiceHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends InternetService> getInternetService(@EndpointParam URI var1);
}

