/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.vcloud.VCloudExpressClient;
import org.jclouds.vcloud.compute.internal.VCloudExpressComputeClientImpl;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.TaskStatus;
import org.jclouds.vcloud.domain.TasksList;
import org.jclouds.vcloud.domain.VCloudExpressVApp;
import org.jclouds.vcloud.domain.VCloudExpressVAppTemplate;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;
import org.jclouds.vcloud.terremark.TerremarkECloudClient;
import org.jclouds.vcloud.terremark.TerremarkVCloudExpressClient;
import org.jclouds.vcloud.terremark.domain.InternetService;
import org.jclouds.vcloud.terremark.domain.Node;
import org.jclouds.vcloud.terremark.domain.Protocol;
import org.jclouds.vcloud.terremark.domain.PublicIpAddress;
import org.jclouds.vcloud.terremark.options.AddInternetServiceOptions;
import org.jclouds.vcloud.terremark.options.AddNodeOptions;
import org.jclouds.vcloud.terremark.options.TerremarkInstantiateVAppTemplateOptions;

@Singleton
public class TerremarkVCloudComputeClient
extends VCloudExpressComputeClientImpl {
    private final TerremarkVCloudExpressClient client;
    private final PopulateDefaultLoginCredentialsForImageStrategy credentialsProvider;
    private Provider<String> passwordGenerator;

    @Inject
    protected TerremarkVCloudComputeClient(TerremarkVCloudExpressClient client, PopulateDefaultLoginCredentialsForImageStrategy credentialsProvider, @Named(value="PASSWORD") Provider<String> passwordGenerator, Predicate<URI> successTester, Map<Status, NodeState> vAppStatusToNodeState) {
        super((VCloudExpressClient)client, successTester, vAppStatusToNodeState);
        this.client = client;
        this.credentialsProvider = credentialsProvider;
        this.passwordGenerator = passwordGenerator;
    }

    protected Map<String, String> parseAndValidateResponse(VCloudExpressVAppTemplate template, VCloudExpressVApp vAppResponse) {
        Credentials credentials = this.credentialsProvider.execute((Object)template);
        Map toReturn = super.parseResponse((Object)template, (ReferenceType)vAppResponse);
        toReturn.put("username", credentials.identity);
        toReturn.put("password", credentials.credential);
        return toReturn;
    }

    public Map<String, String> start(@Nullable URI VDC2, URI templateId, String name, InstantiateVAppTemplateOptions options, int ... portsToOpen) {
        if (options.getDiskSizeKilobytes() != null) {
            this.logger.warn("trmk does not support resizing the primary disk; unsetting disk size", new Object[0]);
        }
        if (portsToOpen.length > 0 && !options.shouldBlock()) {
            throw new IllegalArgumentException("We cannot open ports on terremark unless we can deploy the vapp");
        }
        String password = null;
        VCloudExpressVAppTemplate template = this.client.getVAppTemplate(templateId);
        if (template.getDescription().indexOf("Windows") != -1 && options instanceof TerremarkInstantiateVAppTemplateOptions) {
            password = (String)this.passwordGenerator.get();
            ((TerremarkInstantiateVAppTemplateOptions)((Object)TerremarkInstantiateVAppTemplateOptions.class.cast(options))).getProperties().put("password", password);
        }
        LinkedHashMap<String, String> response = super.start(VDC2, templateId, name, options, portsToOpen);
        if (password != null) {
            response = new LinkedHashMap<String, String>(response);
            response.put("password", password);
        }
        if (portsToOpen.length > 0) {
            this.createPublicAddressMappedToPorts(URI.create((String)response.get("id")), portsToOpen);
        }
        return response;
    }

    public String createPublicAddressMappedToPorts(URI vAppId, int ... ports) {
        VCloudExpressVApp vApp = this.client.getVApp(vAppId);
        PublicIpAddress ip = null;
        String privateAddress = (String)Iterables.getLast((Iterable)vApp.getNetworkToAddresses().values());
        for (int port : ports) {
            Protocol protocol;
            InternetService is = null;
            switch (port) {
                case 22: {
                    protocol = Protocol.TCP;
                    break;
                }
                case 80: 
                case 8080: {
                    protocol = Protocol.HTTP;
                    break;
                }
                case 443: {
                    protocol = Protocol.HTTPS;
                    break;
                }
                default: {
                    protocol = Protocol.HTTP;
                }
            }
            if (ip == null) {
                if (this.client instanceof TerremarkVCloudExpressClient) {
                    is = ((TerremarkVCloudExpressClient)TerremarkVCloudExpressClient.class.cast(this.client)).addInternetServiceToVDC(vApp.getVDC().getHref(), vApp.getName() + "-" + port, protocol, port, AddInternetServiceOptions.Builder.withDescription(String.format("port %d access to serverId: %s name: %s", port, vApp.getName(), vApp.getName())));
                    ip = is.getPublicIpAddress();
                } else {
                    this.logger.debug(">> creating InternetService in vDC %s:%s:%d", new Object[]{vApp.getVDC().getName(), protocol, port});
                    ip = ((TerremarkECloudClient)TerremarkECloudClient.class.cast(this.client)).activatePublicIpInVDC(vApp.getVDC().getHref());
                    is = this.client.addInternetServiceToExistingIp(ip.getId(), vApp.getName() + "-" + port, protocol, port, AddInternetServiceOptions.Builder.withDescription(String.format("port %d access to serverId: %s name: %s", port, vApp.getName(), vApp.getName())));
                }
            } else {
                this.logger.debug(">> adding InternetService %s:%s:%d", new Object[]{ip.getAddress(), protocol, port});
                is = this.client.addInternetServiceToExistingIp(ip.getId(), vApp.getName() + "-" + port, protocol, port, AddInternetServiceOptions.Builder.withDescription(String.format("port %d access to serverId: %s name: %s", port, vApp.getName(), vApp.getName())));
            }
            this.logger.debug("<< created InternetService(%s) %s:%s:%d", new Object[]{is.getName(), is.getPublicIpAddress().getAddress(), is.getProtocol(), is.getPort()});
            this.logger.debug(">> adding Node %s:%d -> %s:%d", new Object[]{is.getPublicIpAddress().getAddress(), is.getPort(), privateAddress, port});
            Node node = this.client.addNode(is.getId(), privateAddress, vApp.getName() + "-" + port, port, new AddNodeOptions[0]);
            this.logger.debug("<< added Node(%s)", new Object[]{node.getName()});
        }
        return ip != null ? ip.getAddress() : null;
    }

    private Set<PublicIpAddress> deleteInternetServicesAndNodesAssociatedWithVApp(VCloudExpressVApp vApp) {
        HashSet ipAddresses = Sets.newHashSet();
        block0: for (InternetService service : this.client.getAllInternetServicesInVDC(vApp.getVDC().getHref())) {
            for (Node node : this.client.getNodes(service.getId())) {
                if (!vApp.getNetworkToAddresses().containsValue((Object)node.getIpAddress())) continue;
                ipAddresses.add(service.getPublicIpAddress());
                this.logger.debug(">> deleting Node(%s) %s:%d -> %s:%d", new Object[]{node.getName(), service.getPublicIpAddress().getAddress(), service.getPort(), node.getIpAddress(), node.getPort()});
                this.client.deleteNode(node.getId());
                this.logger.debug("<< deleted Node(%s)", new Object[]{node.getName()});
                Set<Node> nodes = this.client.getNodes(service.getId());
                if (nodes.size() != 0) continue;
                this.logger.debug(">> deleting InternetService(%s) %s:%d", new Object[]{service.getName(), service.getPublicIpAddress().getAddress(), service.getPort()});
                this.client.deleteInternetService(service.getId());
                this.logger.debug("<< deleted InternetService(%s)", new Object[]{service.getName()});
                continue block0;
            }
        }
        return ipAddresses;
    }

    private void deletePublicIpAddressesWithNoServicesAttached(Set<PublicIpAddress> ipAddresses) {
        for (PublicIpAddress address : ipAddresses) {
            Set<InternetService> services = this.client.getInternetServicesOnPublicIp(address.getId());
            if (services.size() != 0) continue;
            this.logger.debug(">> deleting PublicIpAddress(%s) %s", new Object[]{address.getId(), address.getAddress()});
            this.client.deletePublicIp(address.getId());
            this.logger.debug("<< deleted PublicIpAddress(%s)", new Object[]{address.getId()});
        }
    }

    public void stop(URI id) {
        VCloudExpressVApp vApp = this.client.getVApp(id);
        Set<PublicIpAddress> ipAddresses = this.deleteInternetServicesAndNodesAssociatedWithVApp(vApp);
        this.deletePublicIpAddressesWithNoServicesAttached(ipAddresses);
        if (vApp.getStatus() != Status.OFF) {
            try {
                this.powerOffAndWait(vApp);
            }
            catch (IllegalStateException e) {
                this.logger.warn("<< %s vApp(%s)", new Object[]{e.getMessage(), vApp.getName()});
                this.blockOnLastTask(vApp);
                this.powerOffAndWait(vApp);
            }
            vApp = this.client.getVApp(id);
            this.logger.debug("<< %s vApp(%s)", new Object[]{vApp.getStatus(), vApp.getName()});
        }
        this.logger.debug(">> deleting vApp(%s)", new Object[]{vApp.getName()});
        this.client.deleteVApp(id);
        this.logger.debug("<< deleted vApp(%s))", new Object[]{vApp.getName()});
    }

    private void powerOffAndWait(VCloudExpressVApp vApp) {
        this.logger.debug(">> powering off vApp(%s), current status: %s", new Object[]{vApp.getName(), vApp.getStatus()});
        Task task = this.client.powerOffVApp(vApp.getHref());
        if (!this.taskTester.apply((Object)task.getHref())) {
            throw new RuntimeException(String.format("failed to %s %s: %s", "powerOff", vApp.getName(), task));
        }
    }

    void blockOnLastTask(VCloudExpressVApp vApp) {
        TasksList list = this.client.findTasksListInOrgNamed(null);
        try {
            Task lastTask = (Task)Iterables.getLast((Iterable)Iterables.filter((Iterable)list.getTasks(), (Predicate)new Predicate<Task>(){

                public boolean apply(Task input) {
                    return input.getStatus() == TaskStatus.QUEUED || input.getStatus() == TaskStatus.RUNNING;
                }
            }));
            if (!this.taskTester.apply((Object)lastTask.getHref())) {
                throw new RuntimeException(String.format("failed to %s %s: %s", "powerOff", vApp.getName(), lastTask));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public Set<String> getPrivateAddresses(URI id) {
        VCloudExpressVApp vApp = this.client.getVApp(id);
        if (vApp != null) {
            return Sets.newHashSet((Iterable)vApp.getNetworkToAddresses().values());
        }
        return ImmutableSet.of();
    }

    public Set<String> getPublicAddresses(URI id) {
        VCloudExpressVApp vApp = this.client.getVApp(id);
        if (vApp != null) {
            HashSet ipAddresses = Sets.newHashSet();
            for (InternetService service : this.client.getAllInternetServicesInVDC(vApp.getVDC().getHref())) {
                for (Node node : this.client.getNodes(service.getId())) {
                    if (!vApp.getNetworkToAddresses().containsValue((Object)node.getIpAddress())) continue;
                    ipAddresses.add(service.getPublicIpAddress().getAddress());
                }
            }
            return ipAddresses;
        }
        return ImmutableSet.of();
    }
}

