/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.security.SecureRandom;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.config.ComputeServiceTimeoutsModule;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.internal.ComputeServiceContextImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.AddNodeWithTagStrategy;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.RunNodesAndAddToSetStrategy;
import org.jclouds.vcloud.VCloudExpressAsyncClient;
import org.jclouds.vcloud.VCloudExpressClient;
import org.jclouds.vcloud.compute.VCloudExpressComputeClient;
import org.jclouds.vcloud.compute.config.VCloudExpressComputeServiceContextModule;
import org.jclouds.vcloud.compute.strategy.VCloudExpressDestroyNodeStrategy;
import org.jclouds.vcloud.compute.strategy.VCloudExpressListNodesStrategy;
import org.jclouds.vcloud.compute.strategy.VCloudExpressRebootNodeStrategy;
import org.jclouds.vcloud.terremark.compute.TerremarkVCloudComputeClient;
import org.jclouds.vcloud.terremark.compute.TerremarkVCloudComputeService;
import org.jclouds.vcloud.terremark.compute.domain.KeyPairCredentials;
import org.jclouds.vcloud.terremark.compute.domain.OrgAndName;
import org.jclouds.vcloud.terremark.compute.functions.NodeMetadataToOrgAndName;
import org.jclouds.vcloud.terremark.compute.options.TerremarkVCloudTemplateOptions;
import org.jclouds.vcloud.terremark.compute.strategy.ParseVAppTemplateDescriptionToGetDefaultLoginCredentials;
import org.jclouds.vcloud.terremark.compute.strategy.TerremarkEncodeTagIntoNameRunNodesAndAddToSetStrategy;
import org.jclouds.vcloud.terremark.compute.strategy.TerremarkVCloudAddNodeWithTagStrategy;
import org.jclouds.vcloud.terremark.compute.strategy.TerremarkVCloudGetNodeMetadataStrategy;
import org.jclouds.vcloud.terremark.compute.suppliers.VAppTemplatesInOrgs;

public class TerremarkVCloudComputeServiceContextModule
extends VCloudExpressComputeServiceContextModule {
    @Provides
    @Singleton
    Supplier<String> provideSuffix(final SecureRandom random) {
        return new Supplier<String>(){

            public String get() {
                return random.nextInt(4096) + "";
            }
        };
    }

    protected void configure() {
        this.install((Module)new ComputeServiceTimeoutsModule());
        this.bind(AddNodeWithTagStrategy.class).to(TerremarkVCloudAddNodeWithTagStrategy.class);
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceContext>(){}).to((TypeLiteral)new TypeLiteral<ComputeServiceContextImpl<VCloudExpressClient, VCloudExpressAsyncClient>>(){}).in(Scopes.SINGLETON);
        this.bind(RunNodesAndAddToSetStrategy.class).to(TerremarkEncodeTagIntoNameRunNodesAndAddToSetStrategy.class);
        this.bind(ListNodesStrategy.class).to(VCloudExpressListNodesStrategy.class);
        this.bind(GetNodeMetadataStrategy.class).to(TerremarkVCloudGetNodeMetadataStrategy.class);
        this.bind(RebootNodeStrategy.class).to(VCloudExpressRebootNodeStrategy.class);
        this.bind(DestroyNodeStrategy.class).to(VCloudExpressDestroyNodeStrategy.class);
        this.bindLoadBalancer();
        this.bind((TypeLiteral)new TypeLiteral<Function<NodeMetadata, OrgAndName>>(){}).to((TypeLiteral)new TypeLiteral<NodeMetadataToOrgAndName>(){});
        this.bind(TemplateOptions.class).to(TerremarkVCloudTemplateOptions.class);
        this.bind(ComputeService.class).to(TerremarkVCloudComputeService.class);
        this.bind(VCloudExpressComputeClient.class).to(TerremarkVCloudComputeClient.class);
        this.bind(PopulateDefaultLoginCredentialsForImageStrategy.class).to(ParseVAppTemplateDescriptionToGetDefaultLoginCredentials.class);
        this.bind(SecureRandom.class).toInstance((Object)new SecureRandom());
    }

    @Provides
    @Singleton
    ConcurrentMap<OrgAndName, KeyPairCredentials> credentialsMap() {
        return new ConcurrentHashMap<OrgAndName, KeyPairCredentials>();
    }

    @Named(value="PASSWORD")
    @Provides
    String providePassword(SecureRandom random) {
        return random.nextLong() + "";
    }

    protected Supplier<Set<? extends Image>> getSourceImageSupplier(Injector injector) {
        return (Supplier)injector.getInstance(VAppTemplatesInOrgs.class);
    }
}

