/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.strategy;

import java.util.concurrent.ConcurrentMap;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.terremark.TerremarkVCloudExpressClient;
import org.jclouds.vcloud.terremark.compute.domain.KeyPairCredentials;
import org.jclouds.vcloud.terremark.compute.domain.OrgAndName;
import org.jclouds.vcloud.terremark.domain.KeyPair;

@Singleton
public class DeleteKeyPair {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    final TerremarkVCloudExpressClient terremarkClient;
    final ConcurrentMap<OrgAndName, KeyPairCredentials> credentialsMap;

    @Inject
    DeleteKeyPair(TerremarkVCloudExpressClient terremarkClient, ConcurrentMap<OrgAndName, KeyPairCredentials> credentialsMap) {
        this.terremarkClient = terremarkClient;
        this.credentialsMap = credentialsMap;
    }

    public void execute(OrgAndName orgTag) {
        for (KeyPair keyPair : this.terremarkClient.listKeyPairsInOrg(orgTag.getOrg())) {
            if (!keyPair.getName().matches("jclouds#" + orgTag.getName() + "#[0-9a-f]+")) continue;
            this.logger.debug(">> deleting keyPair(%s)", new Object[]{keyPair.getName()});
            this.terremarkClient.deleteKeyPair(keyPair.getId());
            this.credentialsMap.remove(orgTag);
            this.logger.debug("<< deleted keyPair(%s)", new Object[]{keyPair.getName()});
        }
    }
}

