/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.strategy;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.vcloud.domain.VCloudExpressVAppTemplate;

@Singleton
public class ParseVAppTemplateDescriptionToGetDefaultLoginCredentials
implements PopulateDefaultLoginCredentialsForImageStrategy {
    public static final Pattern USER_PASSWORD_PATTERN = Pattern.compile(".*[Uu]sername: ([a-z]+) ?.*\n[Pp]assword: ([^ \n\r]+) ?\r?\n.*");

    public Credentials execute(Object resourceToAuthenticate) {
        String search;
        Preconditions.checkNotNull((Object)resourceToAuthenticate);
        Preconditions.checkArgument((boolean)(resourceToAuthenticate instanceof VCloudExpressVAppTemplate), (Object)"Resource must be an VAppTemplate (for Terremark)");
        VCloudExpressVAppTemplate template = (VCloudExpressVAppTemplate)resourceToAuthenticate;
        String string = search = template.getDescription() != null ? template.getDescription() : template.getName();
        if (search.indexOf("Windows") >= 0) {
            return new Credentials("Administrator", null);
        }
        Matcher matcher = USER_PASSWORD_PATTERN.matcher(search);
        if (matcher.find()) {
            return new Credentials(matcher.group(1), matcher.group(2));
        }
        throw new RuntimeException("could not parse username/password for image: " + template.getHref() + "\n" + search);
    }
}

