/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.strategy;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.strategy.AddNodeWithTagStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.vcloud.terremark.TerremarkVCloudClient;
import org.jclouds.vcloud.terremark.compute.TerremarkVCloudComputeClient;
import org.jclouds.vcloud.terremark.compute.functions.TemplateToInstantiateOptions;
import org.jclouds.vcloud.terremark.options.TerremarkInstantiateVAppTemplateOptions;

@Singleton
public class TerremarkVCloudAddNodeWithTagStrategy
implements AddNodeWithTagStrategy {
    protected final TerremarkVCloudClient client;
    protected final TerremarkVCloudComputeClient computeClient;
    protected final GetNodeMetadataStrategy getNode;
    protected final TemplateToInstantiateOptions getOptions;

    @Inject
    protected TerremarkVCloudAddNodeWithTagStrategy(TerremarkVCloudClient client, TerremarkVCloudComputeClient computeClient, GetNodeMetadataStrategy getNode, TemplateToInstantiateOptions getOptions) {
        this.client = client;
        this.computeClient = computeClient;
        this.getNode = getNode;
        this.getOptions = (TemplateToInstantiateOptions)Preconditions.checkNotNull((Object)getOptions, (Object)"getOptions");
    }

    public NodeMetadata execute(String tag, String name, Template template) {
        TerremarkInstantiateVAppTemplateOptions options = this.getOptions.apply(template);
        Map<String, String> metaMap = this.computeClient.start(URI.create(template.getLocation().getId()), URI.create(template.getImage().getId()), name, options, template.getOptions().getInboundPorts());
        return this.getNode.execute(metaMap.get("id"));
    }
}

