/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudExpressClient;
import org.jclouds.vcloud.compute.VCloudExpressComputeClient;
import org.jclouds.vcloud.compute.domain.VCloudLocation;
import org.jclouds.vcloud.compute.functions.FindLocationForResource;
import org.jclouds.vcloud.compute.functions.HardwareForVCloudExpressVApp;
import org.jclouds.vcloud.compute.strategy.VCloudExpressGetNodeMetadataStrategy;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.terremark.compute.domain.KeyPairCredentials;
import org.jclouds.vcloud.terremark.compute.domain.OrgAndName;

@Singleton
public class TerremarkVCloudGetNodeMetadataStrategy
extends VCloudExpressGetNodeMetadataStrategy {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final ConcurrentMap<OrgAndName, KeyPairCredentials> credentialsMap;

    @Inject
    protected TerremarkVCloudGetNodeMetadataStrategy(VCloudExpressClient client, VCloudExpressComputeClient computeClient, Map<Status, NodeState> vAppStatusToNodeState, HardwareForVCloudExpressVApp getExtra, FindLocationForResource findLocationForResourceInVDC, Supplier<Set<? extends Image>> images, ConcurrentMap<OrgAndName, KeyPairCredentials> credentialsMap) {
        super(client, computeClient, vAppStatusToNodeState, getExtra, findLocationForResourceInVDC, images);
        this.credentialsMap = credentialsMap;
    }

    public NodeMetadata execute(String id) {
        NodeMetadata node = super.execute((String)Preconditions.checkNotNull((Object)id, (Object)"node.id"));
        if (node == null) {
            return null;
        }
        if (node.getTag() != null) {
            node = this.installCredentialsFromCache(node);
        }
        return node;
    }

    NodeMetadata installCredentialsFromCache(NodeMetadata node) {
        OrgAndName orgAndName = this.getOrgAndNameFromNode(node);
        if (this.credentialsMap.containsKey(orgAndName)) {
            Credentials creds = (Credentials)this.credentialsMap.get(orgAndName);
            node = ComputeServiceUtils.installNewCredentials((NodeMetadata)node, (Credentials)creds);
        }
        return node;
    }

    OrgAndName getOrgAndNameFromNode(NodeMetadata node) {
        URI orgId = ((VCloudLocation)VCloudLocation.class.cast(node.getLocation().getParent())).getResource().getHref();
        OrgAndName orgAndName = new OrgAndName(orgId, node.getTag());
        return orgAndName;
    }
}

