/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.inject.Provides;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.RequiresHttp;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.suppliers.RetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.util.Utils;
import org.jclouds.vcloud.VCloudExpressAsyncClient;
import org.jclouds.vcloud.VCloudExpressClient;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VCloudSession;
import org.jclouds.vcloud.terremark.TerremarkVCloudAsyncClient;
import org.jclouds.vcloud.terremark.TerremarkVCloudClient;
import org.jclouds.vcloud.terremark.TerremarkVCloudExpressAsyncClient;
import org.jclouds.vcloud.terremark.TerremarkVCloudExpressClient;
import org.jclouds.vcloud.terremark.config.TerremarkRestClientModule;
import org.jclouds.vcloud.terremark.endpoints.KeysList;

@RequiresHttp
@ConfiguresRestClient
public class TerremarkVCloudExpressRestClientModule
extends TerremarkRestClientModule<TerremarkVCloudExpressClient, TerremarkVCloudExpressAsyncClient> {
    public TerremarkVCloudExpressRestClientModule() {
        super(TerremarkVCloudExpressClient.class, TerremarkVCloudExpressAsyncClient.class);
    }

    @Provides
    @Singleton
    protected VCloudExpressAsyncClient provideVCloudAsyncClient(TerremarkVCloudExpressAsyncClient in) {
        return in;
    }

    @Provides
    @Singleton
    protected VCloudExpressClient provideVCloudClient(TerremarkVCloudExpressClient in) {
        return in;
    }

    @Provides
    @Singleton
    protected TerremarkVCloudAsyncClient provideTerremarkAsyncClient(TerremarkVCloudExpressAsyncClient in) {
        return in;
    }

    @Provides
    @Singleton
    protected TerremarkVCloudClient provideTerremarkClient(TerremarkVCloudExpressClient in) {
        return in;
    }

    @Provides
    @Singleton
    @KeysList
    protected Supplier<Map<String, ReferenceType>> provideOrgToKeysListCache(@Named(value="jclouds.session-interval") long seconds, final OrgNameToKeysListSupplier supplier) {
        return new RetryOnTimeOutButNotOnAuthorizationExceptionSupplier(this.authException, seconds, (Supplier)new Supplier<Map<String, ReferenceType>>(){

            public Map<String, ReferenceType> get() {
                return supplier.get();
            }
        });
    }

    @Singleton
    @Provides
    @Named(value="CreateKey")
    String provideCreateKey() throws IOException {
        return Utils.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/terremark/CreateKey.xml"));
    }

    @Singleton
    public static class OrgNameToKeysListSupplier
    implements Supplier<Map<String, ReferenceType>> {
        protected final Supplier<VCloudSession> sessionSupplier;
        private final TerremarkVCloudExpressClient client;

        @Inject
        protected OrgNameToKeysListSupplier(Supplier<VCloudSession> sessionSupplier, TerremarkVCloudExpressClient client) {
            this.sessionSupplier = sessionSupplier;
            this.client = client;
        }

        public Map<String, ReferenceType> get() {
            return Maps.transformValues((Map)((VCloudSession)this.sessionSupplier.get()).getOrgs(), (Function)new Function<ReferenceType, ReferenceType>(){

                public ReferenceType apply(ReferenceType from) {
                    return OrgNameToKeysListSupplier.this.client.findOrgNamed(from.getName()).getKeysList();
                }
            });
        }
    }
}

