/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.domain;

import java.net.URI;
import org.jclouds.vcloud.terremark.domain.Protocol;
import org.jclouds.vcloud.terremark.domain.PublicIpAddress;

public class InternetService
implements Comparable<InternetService> {
    private final String name;
    private final URI id;
    private final PublicIpAddress publicIpAddress;
    private final int port;
    private final Protocol protocol;
    private final boolean enabled;
    private final int timeout;
    private final String description;

    public InternetService(String name, URI id, PublicIpAddress publicIpAddress, int port, Protocol protocol, boolean enabled, int timeout, String description) {
        this.name = name;
        this.id = id;
        this.publicIpAddress = publicIpAddress;
        this.port = port;
        this.protocol = protocol;
        this.enabled = enabled;
        this.timeout = timeout;
        this.description = description;
    }

    public PublicIpAddress getPublicIpAddress() {
        return this.publicIpAddress;
    }

    public int getPort() {
        return this.port;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public URI getId() {
        return this.id;
    }

    @Override
    public int compareTo(InternetService that) {
        return this == that ? 0 : this.getId().compareTo(that.getId());
    }

    public String toString() {
        return "InternetService [description=" + this.description + ", enabled=" + this.enabled + ", id=" + this.id + ", name=" + this.name + ", port=" + this.port + ", protocol=" + (Object)((Object)this.protocol) + ", publicIpAddress=" + this.publicIpAddress + ", timeout=" + this.timeout + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.publicIpAddress == null ? 0 : this.publicIpAddress.hashCode());
        result = 31 * result + this.timeout;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InternetService other = (InternetService)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.protocol == null ? other.protocol != null : !this.protocol.equals((Object)other.protocol)) {
            return false;
        }
        if (this.publicIpAddress == null ? other.publicIpAddress != null : !this.publicIpAddress.equals(other.publicIpAddress)) {
            return false;
        }
        return this.timeout == other.timeout;
    }
}

